/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import jeus.deploy.archivist.AbstractArchive;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.util.JeusRemoteClassLoader;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.WebModuleMBean;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.enginecontainer.StartThread;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.properties.JeusEJBPropertyValues;
import sun.misc.CompoundEnumeration;

public class EJBRootClassLoader
extends URLClassLoader
implements JeusRemoteClassLoader {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.classloader.rootloader");
    private static final String clsp = File.pathSeparator;
    private RootClassLoader parent;
    private final CopyOnWriteArrayList loaderList = new CopyOnWriteArrayList();
    private String classpath = "";
    private static boolean initialized = false;
    private final HashMap counterTable = new HashMap();

    public EJBRootClassLoader(URL[] url, ClassLoader parent, String containerName) throws JeusException {
        super(url, parent);
        try {
            this.parent = (RootClassLoader)parent;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB10._6051_LEVEL)) {
                logger.logp(JeusMessage_EJB10._6051_LEVEL, "EJBRootClassLoader", "<init>", JeusMessage_EJB10._6051, (Object)containerName, t);
            }
            throw new JeusException(JeusMessage_EJB10._6051, (Object)containerName, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CopyOnWriteArrayList copyOnWriteArrayList = this.loaderList;
        synchronized (copyOnWriteArrayList) {
            for (Object aLoaderList : this.loaderList) {
                ((ArchiveArrayClassLoader)aLoaderList).clear();
            }
            this.loaderList.clear();
            this.classpath = "";
        }
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Object[] loaderArray;
        Class classObj = super.findLoadedClass(className);
        if (classObj != null) {
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        ArchiveArrayClassLoader archiveLoader = null;
        for (Object loader : loaderArray = this.loaderList.toArray()) {
            archiveLoader = (ArchiveArrayClassLoader)loader;
            Object obj = archiveLoader.findLoadedClassFromTable(className);
            if (obj == null) continue;
            if (!(obj instanceof Class)) break;
            classObj = (Class)obj;
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        if ((classObj = this.parent.loadClassFromSuper(className, false)) != null) {
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        try {
            classObj = super.findClass(className);
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        catch (ClassNotFoundException e) {
            if (archiveLoader != null && (classObj = archiveLoader.loadClassWithoutDelegation(className)) != null) {
                if (resolve) {
                    this.resolveClass(classObj);
                }
                return classObj;
            }
            throw new ClassNotFoundException(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String moduleName) throws EJBServerException {
        ArchiveArrayClassLoader loader = null;
        boolean removed = false;
        CopyOnWriteArrayList copyOnWriteArrayList = this.loaderList;
        synchronized (copyOnWriteArrayList) {
            for (int i = 0; i < this.loaderList.size(); ++i) {
                loader = (ArchiveArrayClassLoader)this.loaderList.get(i);
                if (!loader.getLoaderName().equals(moduleName)) continue;
                String removedClassPath = loader.getClassPath();
                int idx = this.classpath.indexOf(removedClassPath);
                if (idx != -1) {
                    String preString = this.classpath.substring(0, idx);
                    String postString = this.classpath.substring(idx + removedClassPath.length());
                    this.classpath = preString + postString;
                }
                this.loaderList.remove(i);
                loader.clear();
                if (logger.isLoggable(JeusMessage_EJB10._6052_LEVEL)) {
                    logger.logp(JeusMessage_EJB10._6052_LEVEL, "EJBRootClassLoader", "remove", JeusMessage_EJB10._6052, (Object)moduleName);
                }
                removed = true;
                break;
            }
        }
        if (removed) {
            loader.clear();
            EJBRootClassLoader.reloadWebContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String moduleName, ArchiveArrayClassLoader loader, boolean isIsolated) throws JeusException, MalformedURLException {
        if (!isIsolated) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.loaderList;
            synchronized (copyOnWriteArrayList) {
                for (Object aLoaderList : this.loaderList) {
                    ArchiveArrayClassLoader archiveLoader = (ArchiveArrayClassLoader)aLoaderList;
                    if (!archiveLoader.getLoaderName().equals(moduleName)) continue;
                    return;
                }
                this.loaderList.add(loader);
                if (logger.isLoggable(JeusMessage_EJB10._6054_LEVEL)) {
                    logger.logp(JeusMessage_EJB10._6054_LEVEL, "EJBRootClassLoader", "load", JeusMessage_EJB10._6054, (Object)moduleName);
                }
                if (!this.classpath.equals("")) {
                    this.classpath = this.classpath + clsp;
                }
                this.classpath = this.classpath + loader.getClassPath();
            }
        }
        this.setLoaderInfo(loader, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLoaderInfo(ArchiveArrayClassLoader loader, String moduleName) {
        int count;
        HashMap hashMap = this.counterTable;
        synchronized (hashMap) {
            Integer counter = (Integer)this.counterTable.get(moduleName);
            count = counter == null ? 0 : counter + 1;
            this.counterTable.put(moduleName, count);
        }
        loader.setCount(count);
    }

    public String getClassPath() {
        return this.classpath;
    }

    public String getClassPath(String moduleName) {
        Object[] loaderArray;
        for (Object loader : loaderArray = this.loaderList.toArray()) {
            ArchiveArrayClassLoader archiveLoader = (ArchiveArrayClassLoader)loader;
            if (!archiveLoader.getLoaderName().equals(moduleName)) continue;
            return archiveLoader.getClassPath();
        }
        throw new JeusRuntimeException("The classloader corresponding to the module name " + moduleName + " does not exist");
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void setInitialized() {
        initialized = true;
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public String getCodeBasePath(String className) {
        Object[] loaderArray;
        for (Object loader : loaderArray = this.loaderList.toArray()) {
            ArchiveArrayClassLoader archiveLoader = (ArchiveArrayClassLoader)loader;
            if (!archiveLoader.isIncluded(className)) continue;
            return archiveLoader.getCodeBasePath(className);
        }
        return null;
    }

    public URL[] getURLs() {
        return RootClassLoader.DUMMY_URL;
    }

    public AbstractArchive getCorrespondingArchive(String className) {
        Object[] loaderArray;
        for (Object aLoaderArray : loaderArray = this.loaderList.toArray()) {
            ArchiveArrayClassLoader loader = (ArchiveArrayClassLoader)aLoaderArray;
            if (!loader.isIncluded(className)) continue;
            return loader.getCorrespondingArchive(className);
        }
        return null;
    }

    public Class loadClassIsolated(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> classObj = super.findLoadedClass(className);
        if (classObj != null) {
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        classObj = this.parent.loadClassFromSuper(className, false);
        if (classObj != null) {
            if (resolve) {
                this.resolveClass(classObj);
            }
            return classObj;
        }
        classObj = super.findClass(className);
        if (resolve) {
            this.resolveClass(classObj);
        }
        return classObj;
    }

    public URL getResource(String name) {
        URL url = this.parent.getResourceFromSuper(name);
        if (url == null) {
            url = this.findResource(name);
        }
        if (url == null) {
            Object aLoaderArray;
            ArchiveArrayClassLoader loader;
            Object[] loaderArray;
            Object[] arr$ = loaderArray = this.loaderList.toArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (url = (loader = (ArchiveArrayClassLoader)(aLoaderArray = arr$[i$])).findResource(name)) == null; ++i$) {
            }
        }
        return url;
    }

    public URL getResourceFromSuper(String name) {
        URL url = this.parent.getResourceFromSuper(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        Object[] loaderArray;
        ArrayList<Enumeration> list = new ArrayList<Enumeration>();
        list.add(super.findResources(name));
        for (Object aLoaderArray : loaderArray = this.loaderList.toArray()) {
            ArchiveArrayClassLoader loader = (ArchiveArrayClassLoader)aLoaderArray;
            list.add(loader.findResourcesWithoutDelegate(name));
        }
        return new CompoundEnumeration(list.toArray(new Enumeration[list.size()]));
    }

    public static void reloadWebContainer() throws EJBServerException {
        Map notReloadContextsMap;
        if (EngineContainer.isDown()) {
            return;
        }
        if (logger.isLoggable(JeusMessage_EJB8._5159_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5159_LEVEL, "EJBServer", "reloadWebContainer", JeusMessage_EJB8._5159);
        }
        if ((notReloadContextsMap = JeusEJBPropertyValues.notReloadContextsMap).containsKey("*")) {
            return;
        }
        try {
            if (StartThread.webContainer != null) {
                WebModuleMBean[] webModules;
                MBeanServer mbs = JMXManager.getMbeanServer();
                for (WebModuleMBean webModule1 : webModules = JMXUtility.getProxy((MBeanServerConnection)mbs, JMXUtility.queryWebModules(mbs), WebModuleMBean.class, false)) {
                    WebModuleMBean webModule = webModule1;
                    List contexts = (List)notReloadContextsMap.get(webModule.getContextGroup().getName());
                    if (contexts != null && (contexts.contains("*") || contexts.contains(webModule.getObjectName().getKeyProperty("name"))) || webModule.isIsolatedClassloading()) continue;
                    webModule.reload();
                }
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB8._5163_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5163_LEVEL, "EJBServer", "reloadWebContainer", JeusMessage_EJB8._5163, t);
            }
            throw new EJBServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB8._5163));
        }
    }

    public String printLoaderList() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.loaderList.iterator();
        for (Object loader : this.loaderList) {
            buffer.append(loader.toString()).append(",");
        }
        return buffer.toString();
    }
}

