/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MethodTable
implements Serializable {
    private static final long serialVersionUID = 60L;
    protected Map<String, Object> methodAttrMap = new HashMap<String, Object>();

    public void add(String name, Class[] paramTypes, Object attribute) {
        String key = this.makeKey(name, paramTypes);
        this.methodAttrMap.put(key, attribute);
    }

    public void add(String key, Object attribute) {
        this.methodAttrMap.put(key, attribute);
    }

    public Object getValue(Method m) {
        String key = this.makeKey(m.getName(), m.getParameterTypes());
        Object attr = this.methodAttrMap.get(key);
        if (attr != null) {
            return attr;
        }
        key = this.makeKey(m.getName(), null);
        attr = this.methodAttrMap.get(key);
        if (attr != null) {
            return attr;
        }
        key = this.makeKey(null, null);
        attr = this.methodAttrMap.get(key);
        if (attr != null) {
            return attr;
        }
        return null;
    }

    public Object getValue(String methodSig) {
        String key;
        Object attr = this.methodAttrMap.get(methodSig);
        if (attr != null) {
            return attr;
        }
        int paramBegin = methodSig.indexOf(40);
        if (paramBegin > -1 && (attr = this.methodAttrMap.get(key = this.makeKey(methodSig.substring(0, paramBegin), null))) != null) {
            return attr;
        }
        key = this.makeKey(null, null);
        attr = this.methodAttrMap.get(key);
        if (attr != null) {
            return attr;
        }
        return null;
    }

    public Set keySet() {
        return this.methodAttrMap.keySet();
    }

    public void remove(String name, Class[] methodParams) {
        String paramsString = this.makeKey(name, methodParams);
        Set<String> keys = this.methodAttrMap.keySet();
        if (keys != null) {
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (!key.equals(paramsString)) continue;
                it.remove();
            }
        }
    }

    public void remove(String name) {
        Set<String> keys = this.methodAttrMap.keySet();
        if (keys != null) {
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (key.indexOf(name = name + "(") <= -1) continue;
                it.remove();
            }
        }
    }

    public void clear() {
        if (this.methodAttrMap.size() > 0) {
            this.methodAttrMap.clear();
        }
    }

    private String makeKey(String name, Class[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        if (name == null) {
            buf.append("*");
        } else {
            buf.append(name);
            buf.append("(");
            if (paramTypes == null) {
                buf.append("*");
            } else {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(paramTypes[i].getName());
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public int size() {
        return this.methodAttrMap.size();
    }

    public boolean isEmpty() {
        return this.methodAttrMap.isEmpty();
    }

    public String toString() {
        return this.methodAttrMap.toString();
    }
}

