/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public abstract class AbstractJeusPooledConnection
implements JeusPooledConnection {
    protected final ConnectionPoolImpl connectionPool;
    protected final PooledConnection actualPooledConn;
    protected Connection connectionHandle;
    protected volatile boolean isShared;
    protected boolean isRawConnection;
    private volatile int referenceCount = 0;
    private boolean closable = true;
    private boolean reuseConnectionHandle;
    private volatile boolean forcedClosed;
    private volatile boolean abnormallyClosed;
    private final PooledConnectionInfo info;
    protected XAResourceWrapper xaResourceWrapper;
    protected final long stmtQueryTimeout;
    private long startToUseTime;
    private long lastValidatedTime;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private final DynamicPoolStatsAndInfo stats;
    private ConnectionEventListener connectionEventListener;

    AbstractJeusPooledConnection(PooledConnection delegated, String connectionId, ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder, boolean disposable) throws SQLException {
        this.connectionPool = cp;
        this.actualPooledConn = delegated;
        this.stmtQueryTimeout = cp.getConnectionPoolInfo().getStmtQueryTimeout();
        this.info = new PooledConnectionInfo(connectionId, false, 0, System.currentTimeMillis(), -1, disposable);
        this.stats = statHolder;
        this.stats.addPooledConnectionInfo(this.info);
        if (cp.getConnectionPoolInfo().isKeepConnectionHandleOpen()) {
            this.setReuseConnectionHandle(true);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getJeusConnection();
    }

    public Connection getActualHandle() throws SQLException {
        if (this.connectionHandle == null) {
            this.connectionHandle = this.actualPooledConn.getConnection();
        }
        return this.connectionHandle;
    }

    public void closeConnectionHandle(JeusConnection connection) throws SQLException {
        this.connectionPool.removeConnectionResource(this, connection);
        if (this.decrementReferenceAndGet() <= 0 && this.closable) {
            this.closeActualHandle();
        }
    }

    public void closeConnectionHandleAfterTxCompletion() throws SQLException {
        if (logger.isLoggable(JeusMessage_JDBC._348_LEVEL)) {
            logger.log(JeusMessage_JDBC._348_LEVEL, JeusMessage_JDBC._348, (Object)this.toString());
        }
        this.setClosable(true);
        if (this.getReferenceCount() <= 0) {
            this.closeActualHandle();
        }
    }

    protected void closeActualHandle() throws SQLException {
        assert (this.connectionHandle != null);
        this.referenceCount = 0;
        this.stats.addUseTimeStat(this.startToUseTime);
        if (this.abnormallyClosed()) {
            return;
        }
        if (!this.reuseConnectionHandle) {
            try {
                this.connectionHandle.close();
            }
            catch (Throwable th) {
                if (!this.isRawConnection) {
                    this.connectionPool.connectionErrorOccurred(this);
                }
                if (th instanceof SQLException) {
                    throw (SQLException)th;
                }
                throw new JeusSQLException(th);
            }
            finally {
                this.connectionHandle = null;
            }
        }
        if (this.abnormallyClosed()) {
            return;
        }
        if (this.isRawConnection) {
            return;
        }
        this.isShared = false;
        this.connectionPool.connectionClosed(this);
    }

    public void commitConnectionHandle() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.commit();
        }
    }

    public void rollbackConnectionHandle() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.rollback();
        }
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    public boolean isShared() {
        return this.isShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.actualPooledConn.close();
        }
        finally {
            this.xaResourceWrapper = null;
            this.stats.removePooledConnectionInfo(this.info);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.actualPooledConn.addConnectionEventListener(listener);
        this.connectionEventListener = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.actualPooledConn.removeConnectionEventListener(listener);
        this.connectionEventListener = null;
    }

    public void removeConnectionEventListener() {
        this.removeConnectionEventListener(this.connectionEventListener);
    }

    public XAResource getXAResource() throws SQLException {
        return ((XAConnection)this.actualPooledConn).getXAResource();
    }

    public XAResourceWrapper getXaResourceWrapper() {
        return this.xaResourceWrapper;
    }

    public void setXaResourceWrapper(XAResourceWrapper wrapper) {
        this.xaResourceWrapper = wrapper;
    }

    public boolean isDisposable() {
        return this.info.isDisposable();
    }

    public void changeToActive() {
        if (!this.isDisposable() && !this.isActive()) {
            this.stats.incActiveConnections();
        }
        this.info.setIsActive(true);
        this.setStateChangedTime(System.currentTimeMillis());
    }

    public boolean isActive() {
        return this.info.isActive();
    }

    public void changeToIdle() {
        if (!this.isDisposable() && this.isActive()) {
            this.stats.decActiveConnections();
        }
        this.info.setIsActive(false);
        long currentTime = System.currentTimeMillis();
        this.setStateChangedTime(currentTime);
        this.setLastValidTime(currentTime);
    }

    public void setLastValidTime(long lastValidatedTime) {
        this.lastValidatedTime = lastValidatedTime;
    }

    public long getLastValidTime() {
        return this.lastValidatedTime;
    }

    public void incUseCount() {
        this.info.incUseCount();
    }

    public int getUseCount() {
        return this.info.getUseCount();
    }

    public long getStateChangedTime() {
        return this.info.getStateChangedTime();
    }

    public void setStateChangedTime(long time) {
        this.info.setStateChangedTime(time);
    }

    public void setConnectionId(String id) {
        this.info.setConnectionId(id);
    }

    public String getConnectionId() {
        return this.info.getConnectionId();
    }

    public int getGeneration() {
        return this.info.getGeneration();
    }

    public void setGeneration(int generation) {
        this.info.setGeneration(generation);
    }

    protected void incrementReferenceCount() {
        if (this.referenceCount == 0) {
            this.startToUseTime = System.currentTimeMillis();
        }
        ++this.referenceCount;
    }

    protected int decrementReferenceAndGet() {
        return --this.referenceCount;
    }

    protected int getReferenceCount() {
        return this.referenceCount;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    protected boolean isReuseConnectionHandle() {
        return this.reuseConnectionHandle;
    }

    protected void setReuseConnectionHandle(boolean reuseConnectionHandle) {
        this.reuseConnectionHandle = reuseConnectionHandle;
    }

    public boolean isRawConnection() {
        return this.isRawConnection;
    }

    public void setRawConnection(boolean rawConnection) {
        this.isRawConnection = rawConnection;
    }

    public boolean isForcedClosed() {
        return this.forcedClosed;
    }

    public void setForcedClosed(boolean forcedClosed) {
        this.forcedClosed = forcedClosed;
    }

    public boolean abnormallyClosed() {
        return this.abnormallyClosed;
    }

    public void setAbnormallyClosed(boolean abnormallyClosed) {
        this.abnormallyClosed = abnormallyClosed;
    }

    public void setConnectionTrace(JeusConnectionImpl jeusConn) {
        this.info.setConnectionTrace(jeusConn);
    }

    public void unsetConnectionTrace(JeusConnectionImpl jeusConn) {
        this.info.unsetConnectionTrace(jeusConn);
    }

    public String toString() {
        return "JeusPooledConnection[ID=" + this.info.getConnectionId() + ",actual=" + this.actualPooledConn + "]";
    }
}

