/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.SQLException;
import javax.sql.PooledConnection;
import jeus.jdbc.common.AbstractJeusPooledConnection;
import jeus.jdbc.common.JeusCacheConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPreparedStatement;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.util.CacheHashtable;

public class JeusCachePooledConnection
extends AbstractJeusPooledConnection {
    private final CacheHashtable cache;

    public JeusCachePooledConnection(PooledConnection pcon, String connectionId, DynamicPoolStatsAndInfo stats, ConnectionPoolImpl cp, boolean disposable) throws SQLException {
        super(pcon, connectionId, cp, stats, disposable);
        this.cache = new CacheHashtable(cp.getConnectionPoolInfo().getStmtCachingSize());
        this.setReuseConnectionHandle(true);
    }

    public JeusConnectionImpl getJeusConnection() throws SQLException {
        JeusCacheConnection con = new JeusCacheConnection(this.getActualHandle(), this.cache, this, this.stmtQueryTimeout);
        this.incrementReferenceCount();
        return con;
    }

    public void close() throws SQLException {
        for (Object o : this.cache.values()) {
            try {
                JeusPreparedStatement jps = (JeusPreparedStatement)o;
                jps.realClose();
            }
            catch (SQLException sQLException) {}
        }
        this.cache.clear();
        super.close();
    }
}

