/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ConnectionEventListenerImpl
implements ConnectionEventListener {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private final ConnectionPool pool;
    private final JeusPooledConnection con;

    public ConnectionEventListenerImpl(ConnectionPool pool, JeusPooledConnection con) {
        this.pool = pool;
        this.con = con;
    }

    public void connectionClosed(ConnectionEvent event) {
        if (logger.isLoggable(JeusMessage_JDBC._2_LEVEL)) {
            logger.log(JeusMessage_JDBC._2_LEVEL, JeusMessage_JDBC._2, new Object[]{this.con, this.pool.getCPInfo().getName()});
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (logger.isLoggable(JeusMessage_JDBC._1_LEVEL)) {
            logger.logp(JeusMessage_JDBC._1_LEVEL, "ConnectionEventListenerImpl", "connectionErrorOccurred", JeusMessage_JDBC._1, (Object)this.con, (Throwable)event.getSQLException());
        }
        this.pool.connectionErrorOccurred(this.con);
    }
}

