/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import jeus.ejb.io.IndirectlySerializable;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.jdbc.JEUSDataSource;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.SerializableDataSourceFactory;

public class DataSourceWrapper
implements JEUSDataSource,
IndirectlySerializable {
    private final ConnectionPoolImpl connectionPool;
    private final boolean shareable;
    private final Resource.AuthenticationType resAuthType;

    public DataSourceWrapper(ConnectionPoolImpl cp, boolean shareable, Resource.AuthenticationType resAuthType) {
        this.connectionPool = cp;
        this.shareable = shareable;
        this.resAuthType = resAuthType;
    }

    ConnectionPoolImpl getConnectionPool() {
        return this.connectionPool;
    }

    boolean isShareable() {
        return this.shareable;
    }

    Resource.AuthenticationType getAuthenticationType() {
        return this.resAuthType;
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection(null, null, this.shareable);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.connectionPool.getConnection(username, password, this.shareable);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.connectionPool.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.connectionPool.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.connectionPool.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.connectionPool.getLoginTimeout();
    }

    public boolean isFailed() {
        return this.connectionPool.isFailed();
    }

    public int getType() {
        return this.connectionPool.getType();
    }

    public String getDriverVendorName() {
        return this.connectionPool.getDriverVendorName();
    }

    public XAConnection getRawXAConnection() throws SQLException {
        return this.connectionPool.getRawXAConnection();
    }

    public void closeRawXAConnection(XAConnection con, boolean abnormalClose) throws SQLException {
        this.connectionPool.closeRawXAConnection(con, abnormalClose);
    }

    public DataSource getDelegateDataSource() {
        return this.connectionPool.getDelegateDataSource();
    }

    public boolean isHandleNullTransaction() {
        return this.connectionPool.isHandleNullTransaction();
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableDataSourceFactory(this);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(32);
        strBuf.append(this.connectionPool.getExportName());
        strBuf.append(";shareable=");
        strBuf.append(this.shareable);
        return strBuf.toString();
    }
}

