/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.queue.JDBCConnectionQueue;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

final class PooledConnectionProviderImpl {
    private final JDBCConnectionQueue connectionQueue;
    private final ConnectionPoolImpl connectionPool;
    private final ConnectionPoolInfo info;
    private final DynamicPoolStatsAndInfo stats;
    private boolean destroyed;
    private final StoreResizingTask resizingTask = new StoreResizingTask();
    private static final ScheduledExecutor periodicJobExecutor = ScheduledExecutor.getInstance();
    private final AtomicBoolean onResizing = new AtomicBoolean(false);
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public PooledConnectionProviderImpl(ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder) {
        this.connectionPool = cp;
        this.info = cp.getConnectionPoolInfo();
        this.stats = statHolder;
        this.connectionQueue = new JDBCConnectionQueue(cp, this.stats);
    }

    public void initProvider() throws SQLException {
        try {
            this.connectionQueue.initConnectionQueue(this.info.getMinPoolSize());
        }
        catch (Exception e) {
            throw new JeusSQLException(e.getMessage(), (Throwable)e);
        }
        long resizingPeriod = this.info.getResizingPeriod();
        if (resizingPeriod > 0L) {
            periodicJobExecutor.scheduleWithFixedDelay(this.resizingTask, resizingPeriod, resizingPeriod);
        }
    }

    public JeusPooledConnection getPooledConnection(String username, String password, boolean returnNullOnEmpty) throws SQLException {
        if (username != null) {
            return this.getNamedConnection(username, password);
        }
        long startTime = System.currentTimeMillis();
        boolean waiting = this.info.isWaiting();
        long waitTimeout = this.info.getWaitingTime();
        try {
            if (waiting) {
                this.stats.incWaitThreadCount();
            }
            JeusPooledConnection pcon = this.connectionQueue.getConnection(waiting, waitTimeout, returnNullOnEmpty);
            if (logger.isLoggable(Level.FINEST) && pcon != null) {
                logger.log(Level.FINEST, "get the physical connection  " + pcon + "- [" + pcon.getConnectionId() + "] from connection pool");
            }
            JeusPooledConnection jeusPooledConnection = pcon;
            return jeusPooledConnection;
        }
        catch (Exception e) {
            if (e instanceof WaitTimeoutException) {
                throw (WaitTimeoutException)e;
            }
            throw new JeusSQLException(e.getMessage() + ", datasource = " + this.info.getExportName(), (Throwable)e);
        }
        finally {
            if (waiting) {
                this.stats.decWaitThreadCount();
                this.stats.addWaitTimeStat(System.currentTimeMillis() - startTime);
            }
        }
    }

    private JeusPooledConnection getNamedConnection(String username, String password) throws SQLException {
        try {
            return this.connectionQueue.getSingleConnection(new Object[]{username, password}, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JeusSQLException(e.getMessage(), (Throwable)e);
        }
    }

    public JeusPooledConnection createNewPooledConnection() throws SQLException {
        JeusPooledConnection newCon;
        try {
            newCon = this.connectionQueue.getSingleConnection(null, false);
        }
        catch (SQLException sqle) {
            logger.log(JeusMessage_JDBC._338_LEVEL, JeusMessage_JDBC._338, (Throwable)sqle);
            throw sqle;
        }
        return newCon;
    }

    public void connectionAbnormallyClosed(JeusPooledConnection oldConnection) throws SQLException {
        try {
            this.connectionQueue.replaceUsedConnection(oldConnection);
        }
        catch (Exception e) {
            throw new JeusSQLException(e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection(JeusPooledConnection con) {
        this.connectionQueue.destroyConnection(con);
    }

    public void returnConnection(JeusPooledConnection con) {
        if (this.destroyed) {
            try {
                con.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        int maxUseCount = this.info.getMaxUseCount();
        if (maxUseCount > 0) {
            con.incUseCount();
            if (con.getUseCount() > maxUseCount) {
                if (logger.isLoggable(JeusMessage_JDBC._356_LEVEL)) {
                    logger.log(JeusMessage_JDBC._356_LEVEL, JeusMessage_JDBC._356, (Object)con.getConnectionId());
                }
                this.replacePooledConnection(con);
                return;
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "putting the physical connection " + con + "  - [" + con.getConnectionId() + "] to connection pool");
        }
        if (!this.connectionQueue.putConnection(con) && logger.isLoggable(JeusMessage_JDBC._357_LEVEL)) {
            logger.log(JeusMessage_JDBC._357_LEVEL, JeusMessage_JDBC._357, (Object)con.getConnectionId());
        }
    }

    private void replacePooledConnection(JeusPooledConnection pooledConn) {
        block2: {
            try {
                this.connectionQueue.replaceUsedConnection(pooledConn);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_JDBC._358_LEVEL)) break block2;
                logger.log(JeusMessage_JDBC._358_LEVEL, JeusMessage_JDBC._358);
            }
        }
    }

    public void updateQueue(Hashtable properties) throws ConnectionPoolException, SQLException {
        if (properties.containsKey("PoolMin") || properties.containsKey("PoolMax") || properties.containsKey("PoolStep")) {
            int currMin = this.info.getMinPoolSize();
            int currMax = this.info.getMaxPoolSize();
            int currStep = this.info.getIncreaseStep();
            try {
                int minPoolSize = currMin;
                int maxPoolSize = currMax;
                int increaseStep = currStep;
                String num = (String)properties.get("PoolMin");
                if (num != null && !num.equals("")) {
                    minPoolSize = Integer.parseInt(num);
                }
                if ((num = (String)properties.get("PoolMax")) != null && !num.equals("")) {
                    maxPoolSize = Integer.parseInt(num);
                }
                if ((num = (String)properties.get("PoolStep")) != null && !num.equals("")) {
                    increaseStep = Integer.parseInt(num);
                }
                if (minPoolSize < 0) {
                    throw new ConnectionPoolException(JeusMessage_JDBC._47, new String[]{this.info.getExportName(), Integer.toString(minPoolSize)});
                }
                if (maxPoolSize <= 0 || minPoolSize > maxPoolSize) {
                    throw new ConnectionPoolException(JeusMessage_JDBC._48, new String[]{this.info.getExportName(), Integer.toString(maxPoolSize)});
                }
                if (increaseStep == 0) {
                    if (maxPoolSize != minPoolSize) {
                        throw new ConnectionPoolException(JeusMessage_JDBC._56, new String[]{this.info.getExportName(), Integer.toString(increaseStep)});
                    }
                } else if (increaseStep < 1 || increaseStep > maxPoolSize) {
                    throw new ConnectionPoolException(JeusMessage_JDBC._49, new String[]{this.info.getExportName(), Integer.toString(increaseStep)});
                }
                this.info.setMaxPoolSize(maxPoolSize);
                this.info.setMinPoolSize(minPoolSize);
                this.info.setIncreaseStep(increaseStep);
            }
            catch (ConnectionPoolException e) {
                if (logger.isLoggable(JeusMessage_JDBC._334_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._334_LEVEL, "ConnectionPool", "update", JeusMessage_JDBC._334, (Object[])new String[]{Integer.toString(currMin), Integer.toString(currMax), Integer.toString(currStep)});
                }
                throw e;
            }
            try {
                this.connectionQueue.refreshQueue(this.info.getMinPoolSize(), this.info.getMaxPoolSize(), this.info.getIncreaseStep());
            }
            catch (Exception e) {
                throw new JeusSQLException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizePool(boolean forcedShrink) throws Exception {
        if (!this.onResizing.compareAndSet(false, true)) {
            return;
        }
        try {
            if (forcedShrink) {
                this.connectionQueue.shrinkPoolToMinimumSize();
            } else {
                this.connectionQueue.resizePool();
            }
        }
        finally {
            this.onResizing.set(false);
        }
    }

    public void refresh() throws SQLException {
        this.connectionQueue.refreshQueue(this.info.getMinPoolSize(), this.info.getMaxPoolSize(), this.info.getIncreaseStep());
    }

    public CPInfo getCPInfo() {
        CPInfo cpInfo = new CPInfo();
        cpInfo.setMin(this.info.getMinPoolSize());
        cpInfo.setMax(this.info.getMaxPoolSize());
        cpInfo.setStep(this.info.getIncreaseStep());
        this.connectionQueue.setCPInfo(cpInfo);
        cpInfo.setResizingPeriod(this.info.getResizingPeriod());
        cpInfo.setName(this.info.getExportName());
        cpInfo.setWaiting(this.info.isWaiting());
        if (this.info.isWaiting()) {
            cpInfo.setWaitingTime(this.info.getWaitingTime());
        }
        return cpInfo;
    }

    public int size() {
        return this.connectionQueue.size();
    }

    public void destroy() {
        this.resizingTask.cancel();
        try {
            this.connectionQueue.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroyed = true;
    }

    private class StoreResizingTask
    extends ScheduleTask {
        private StoreResizingTask() {
        }

        public void run() {
            block2: {
                try {
                    PooledConnectionProviderImpl.this.resizePool(false);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JDBC._334_LEVEL)) break block2;
                    logger.log(JeusMessage_JDBC._334_LEVEL, JeusMessage_JDBC._334, (Object)PooledConnectionProviderImpl.this.info.getExportName(), t);
                }
            }
        }
    }
}

