/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JDBCDataSource;
import jeus.management.j2ee.JDBCDriver;
import jeus.management.j2ee.jdbc.JDBCConnectionInfo;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;

public class ServerConnectionPoolInitializer
implements ConnectionPoolInitializer {
    public void init(ConnectionPool pool) throws Exception {
        if (EngineContainer.jdbcResourceMBean != null) {
            J2EEManagedObject jdbcDataSource = null;
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                String exportName = pool.getExportName();
                jdbcDataSource = (JDBCDataSource)JDBCDataSource.createMBean(exportName, EngineContainer.jdbcResourceMBean.getObjectName(), pool);
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getUseTimeStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getCreateCountStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getWaitingThreadCountStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getCurrentConnectionStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getConnectionPoolMinSizeStat());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getConnectionPoolMaxSizeStat());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getFreePoolSizeStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getWaitTimeStatistic());
                ((JDBCDataSource)jdbcDataSource).setStatistic(pool.getCloseCountStatistic());
                JDBCDriver.createMBean(pool.getDriverVendorName(), jdbcDataSource.getObjectName(), null);
                EngineContainer.jdbcResourceMBean.addJDBCDataSourceStats((JDBCConnectionPoolStats)((JDBCDataSource)jdbcDataSource).getstats());
                JDBCConnectionInfo.createMBean(exportName, jdbcDataSource.getObjectName(), pool);
                pool.putInitializerHandback(jdbcDataSource);
            }
            catch (Exception ex) {
                if (jdbcDataSource != null) {
                    try {
                        jdbcDataSource.destroyMBean();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw ex;
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
    }

    public void destroy(ConnectionPool pool) {
        JDBCDataSource jdbcDataSource = (JDBCDataSource)pool.getInitializerHandback();
        if (jdbcDataSource != null) {
            jdbcDataSource.destroyMBean();
        }
    }
}

