/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ClusterDSBindInfo
implements Serializable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private String exportName = "";
    private boolean isPreConn;
    private boolean useFailback;
    private List dataSourceList;
    private String backupDeletage = "";

    public void validate() throws JeusException {
        if (this.exportName.equals("")) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "ClusterDSBindInfo", "validate", JeusMessage_JDBC._44);
            }
            throw new JeusException(JeusMessage_JDBC._44);
        }
        if (this.dataSourceList == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "ClusterDSBindInfo", "validate", JeusMessage_JDBC._330);
            }
            throw new JeusException(JeusMessage_JDBC._330);
        }
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String s) {
        this.exportName = s;
    }

    public List getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List a) {
        this.dataSourceList = a;
    }

    public void setPreMakeBackupConnection(boolean b) {
        this.isPreConn = b;
    }

    public boolean isPreConn() {
        return this.isPreConn;
    }

    public String toString() {
        StringBuffer s = this.dsListToString();
        return this.exportName + "(" + s.toString() + ")";
    }

    public String getDSList() {
        StringBuffer s = this.dsListToString();
        return s.toString();
    }

    private StringBuffer dsListToString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.dataSourceList.size(); ++i) {
            s.append((String)this.dataSourceList.get(i));
            if (i == this.dataSourceList.size() - 1) continue;
            s.append(",");
        }
        return s;
    }

    public String[] getDSListAsStringArray() {
        int size = this.dataSourceList.size();
        return this.dataSourceList.toArray(new String[size]);
    }

    public String getBackupDelegate() {
        return this.backupDeletage;
    }

    public void setBackupDelegate(String a) {
        this.backupDeletage = a;
    }

    public boolean isUseFailback() {
        return this.useFailback;
    }

    public void setUseFailback(boolean useFailback) {
        this.useFailback = useFailback;
    }
}

