/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.xml.bind.JAXBException;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceGenerator;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.ResourceType;

public final class DataSourceConfigurationTester {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testDataSourceConfiguration(String exportName, String nodeName) throws DBDataSourceException {
        Object aDbDescList;
        JeusMainDescriptor mainDesc;
        try {
            mainDesc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
        }
        catch (JAXBException e) {
            throw new DBDataSourceException("JEUS main descriptor loading failed : XML parsing error");
        }
        catch (IOException e) {
            throw new DBDataSourceException("JEUS main descriptor loading failed : File not found");
        }
        ResourceType rscDesc = mainDesc.getJeusSystem().getResource();
        if (rscDesc == null) throw new DBDataSourceException("There's no resource description.");
        List dbDescList = rscDesc.getDataSource().getDatabase();
        DatabaseType dbDesc = null;
        Iterator i$ = dbDescList.iterator();
        while (i$.hasNext() && !exportName.equals((dbDesc = (DatabaseType)(aDbDescList = i$.next())).getExportName())) {
            dbDesc = null;
        }
        if (dbDesc == null) {
            throw new DBDataSourceException("Couldn't find database with name : " + exportName);
        }
        DBDSBindInfo info = DBDSBindInfoJB.getDBDSBindInfoDescriptor(dbDesc);
        Object dsObj = DataSourceGenerator.getDataSource(info);
        switch (info.getDataSourceType()) {
            case 0: {
                if (!(dsObj instanceof DataSource)) {
                    throw new DBDataSourceException("Wrong data source type : It shall be \"DataSource\".");
                }
                DataSource ds = (DataSource)dsObj;
                Connection con = null;
                try {
                    con = ds.getConnection();
                }
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                        throw new DBDataSourceException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (con == null) throw throwable;
                            con.close();
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (con == null) return;
                    con.close();
                    return;
                }
                catch (SQLException e) {
                    return;
                }
            }
            case 1: 
            case 3: {
                if (!(dsObj instanceof ConnectionPoolDataSource)) {
                    throw new DBDataSourceException("Wrong data source type : It shall be \"ConnectionPoolDataSource\"");
                }
                ConnectionPoolDataSource cpDs = (ConnectionPoolDataSource)dsObj;
                PooledConnection con = null;
                try {
                    con = cpDs.getPooledConnection();
                }
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                        throw new DBDataSourceException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (con == null) throw throwable;
                            con.close();
                            throw throwable;
                        }
                        catch (SQLException e3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (con == null) return;
                    con.close();
                    return;
                }
                catch (SQLException e) {
                    return;
                }
            }
            case 2: {
                if (!(dsObj instanceof XADataSource)) {
                    throw new DBDataSourceException("Wrong data source type : It shall be \"XADataSource\".");
                }
                XADataSource xaDs = (XADataSource)dsObj;
                XAConnection con = null;
                try {
                    con = xaDs.getXAConnection();
                }
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                        throw new DBDataSourceException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (con == null) throw throwable;
                            con.close();
                            throw throwable;
                        }
                        catch (SQLException e4) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (con == null) return;
                    con.close();
                    return;
                }
                catch (SQLException e) {
                    return;
                }
            }
        }
        throw new DBDataSourceException("Unknown data source type specified");
    }
}

