/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import jeus.descriptor.jeusserver.ConnectorProperty;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDSBinder;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.security.util.EncryptionUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class DataSourceGenerator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public static Object getDataSource(DBDSBindInfo info) throws DBDataSourceException {
        try {
            String dataSourceClassName = info.getDataSourceClassName();
            if (dataSourceClassName == null || dataSourceClassName.equals("")) {
                if (logger.isLoggable(JeusMessage_JDBC._54_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._54_LEVEL, "DataSourceGenerator", "getDataSource", JeusMessage_JDBC._54);
                }
                throw new DBDataSourceException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._54));
            }
            Class<?> cl = DBDSBinder.getDSClassLoader().loadClass(dataSourceClassName);
            Object src = cl.newInstance();
            Class[] argTypes = new Class[1];
            Object[] args = new Object[1];
            Enumeration e = info.properties.elements();
            while (e.hasMoreElements()) {
                ConnectorProperty property = (ConnectorProperty)e.nextElement();
                argTypes[0] = DataSourceGenerator.getTypeClass(property.getType());
                args[0] = DataSourceGenerator.getValue(argTypes[0], property.getValue());
                String name = property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
                if (name.equalsIgnoreCase("password")) {
                    args[0] = EncryptionUtil.decryptPassword((String)args[0]);
                    if (args[0] == null) {
                        if (logger.isLoggable(JeusMessage_JDBC._359_LEVEL)) {
                            logger.log(JeusMessage_JDBC._359_LEVEL, JeusMessage_JDBC._359, (Object)info.getExportName());
                        }
                        args[0] = "";
                    }
                }
                try {
                    DBDSBinder.invokeMethod(cl, "set" + name, argTypes, src, args);
                }
                catch (DBDataSourceException ex1) {
                    try {
                        if (name.equalsIgnoreCase("user")) {
                            DBDSBinder.invokeMethod(cl, "setuser", argTypes, src, args);
                            continue;
                        }
                        if (name.equalsIgnoreCase("password")) {
                            DBDSBinder.invokeMethod(cl, "setpassword", argTypes, src, args);
                            continue;
                        }
                        argTypes[0] = DataSourceGenerator.getWrapperClass(argTypes[0]);
                        DBDSBinder.invokeMethod(cl, "set" + name, argTypes, src, args);
                    }
                    catch (Exception ex) {
                        if (name.equalsIgnoreCase("user") || name.equalsIgnoreCase("password")) {
                            argTypes[0] = DataSourceGenerator.getWrapperClass(argTypes[0]);
                            DBDSBinder.invokeMethod(cl, "set" + name, argTypes, src, args);
                            continue;
                        }
                        throw ex;
                    }
                }
            }
            return src;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_JDBC._55_LEVEL)) {
                logger.logp(JeusMessage_JDBC._55_LEVEL, "DataSourceGenerator", "getDataSource", JeusMessage_JDBC._55, (Object)info.getExportName(), ex);
            }
            throw new DBDataSourceException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._55, (Object)info.getExportName()), ex);
        }
    }

    private static Class getTypeClass(String type) {
        if (type.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("java.lang.String")) {
            return String.class;
        }
        if (type.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (type.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        if (type.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (type.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (type.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (type.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        if (type.equals("java.util.Properties")) {
            return Properties.class;
        }
        return Character.TYPE;
    }

    private static Class getWrapperClass(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(String.class)) {
            return String.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        return Character.class;
    }

    public static Object getValue(Class type, String value) {
        if (type.equals(Properties.class)) {
            Properties propeties = new Properties();
            StringUtil.setPropertiesToMap((String)value, (Map)propeties);
            return propeties;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(value);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(value);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(value);
        }
        return new Character(value.charAt(0));
    }
}

