/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.driver.blackbox;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;
import oracle.jdbc.OracleConnection;

public class BlackboxDataSource
implements DataSource,
Referenceable {
    public static final String TRANSACTION_READ_UNCOMMITTED = "READ_UNCOMMITTED";
    public static final String TRANSACTION_READ_COMMITTED = "READ_COMMITTED";
    public static final String TRANSACTION_REPEATABLE_READ = "REPEATABLE_READ";
    public static final String TRANSACTION_SERIALIZABLE = "SERIALIZABLE";
    public static final String TRANSACTION_NONE = "NONE";
    protected String url;
    protected String driverClassName;
    protected String password;
    protected String userName;
    protected String properties = "empty";
    protected Properties property = null;
    protected boolean implicitCahingEnabled = false;
    protected int maxStatements = 0;
    protected String sql = null;
    protected String txIsolation = "";
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public BlackboxDataSource() {
    }

    public BlackboxDataSource(Reference ref) throws SQLException {
        this.url = (String)ref.get(1).getContent();
        this.driverClassName = (String)ref.get(2).getContent();
        this.password = (String)ref.get(3).getContent();
        this.userName = (String)ref.get(4).getContent();
        this.properties = (String)ref.get(5).getContent();
        this.implicitCahingEnabled = Boolean.valueOf((String)ref.get(6).getContent());
        this.maxStatements = Integer.parseInt((String)ref.get(7).getContent());
        this.sql = (String)ref.get(8).getContent();
        if (!this.properties.equals("empty")) {
            this.property = new Properties();
            this.property.put("user", this.userName);
            this.property.put("password", this.password);
            int index = this.properties.indexOf(";");
            while (index != -1) {
                String value = this.properties.substring(0, index);
                this.property.put(value.substring(0, value.indexOf("=")), value.substring(value.indexOf("=") + 1));
                this.properties = this.properties.substring(index + 1);
                index = this.properties.indexOf(";");
            }
            if (!this.properties.equals("")) {
                this.property.put(this.properties.substring(0, this.properties.indexOf("=")), this.properties.substring(this.properties.indexOf("=") + 1));
            }
        }
        this.txIsolation = (String)ref.get(9).getContent();
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isLoggable(JeusMessage_JDBC._217_LEVEL)) {
                logger.logp(JeusMessage_JDBC._217_LEVEL, "BlackboxDataSource", "<init>", JeusMessage_JDBC._217);
            }
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._217, (Object)this.driverClassName));
        }
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.property == null ? DriverManager.getConnection(this.url, this.userName, this.password) : DriverManager.getConnection(this.url, this.property);
        if (this.implicitCahingEnabled) {
            this.setOracleCaching(conn);
        }
        if (this.sql != null) {
            this.executeQuery(conn);
        }
        if (!this.txIsolation.equals("")) {
            conn.setTransactionIsolation(this.convertInt(this.txIsolation));
        }
        return conn;
    }

    protected int convertInt(String txIsolation) throws SQLException {
        if (txIsolation.equalsIgnoreCase(TRANSACTION_READ_UNCOMMITTED)) {
            return 1;
        }
        if (txIsolation.equalsIgnoreCase(TRANSACTION_READ_COMMITTED)) {
            return 2;
        }
        if (txIsolation.equalsIgnoreCase(TRANSACTION_REPEATABLE_READ)) {
            return 4;
        }
        if (txIsolation.equalsIgnoreCase(TRANSACTION_SERIALIZABLE)) {
            return 8;
        }
        if (txIsolation.equalsIgnoreCase(TRANSACTION_NONE)) {
            return 0;
        }
        throw new SQLException("The transaction level is not corrected, use one of NONE, READ_COMMITTED, READ_UNCOMMITTED, REPEATABLE_READ, and SERIALIZABLE");
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Connection conn;
        if (this.property == null) {
            conn = DriverManager.getConnection(this.url, user, password);
        } else {
            this.property.put("user", user);
            this.property.put("password", password);
            conn = DriverManager.getConnection(this.url, this.property);
        }
        if (this.implicitCahingEnabled) {
            this.setOracleCaching(conn);
        }
        if (this.sql != null) {
            this.executeQuery(conn);
        }
        if (!this.txIsolation.equals("")) {
            conn.setTransactionIsolation(this.convertInt(this.txIsolation));
        }
        return conn;
    }

    public void setOracleCaching(Connection conn) throws SQLException {
        OracleConnection con = (OracleConnection)conn;
        con.setImplicitCachingEnabled(this.implicitCahingEnabled);
        con.setStatementCacheSize(this.maxStatements);
    }

    public void executeQuery(Connection con) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(this.sql);
            rs = ps.executeQuery();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._332_LEVEL)) {
                logger.logp(JeusMessage_JDBC._332_LEVEL, "BlackboxDataSource", "executeQuery", JeusMessage_JDBC._332);
            }
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._332, (Object)this.sql));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("jeus.jdbc.driver.blackbox.BlackboxDataSource", "jeus.jdbc.driver.blackbox.BlackboxDataSourceFactory", null);
        ref.add(0, new StringRefAddr("Type", "DataSource"));
        ref.add(1, new StringRefAddr("URL", this.url));
        ref.add(2, new StringRefAddr("DriverClassName", this.driverClassName));
        ref.add(3, new StringRefAddr("Password", this.password));
        ref.add(4, new StringRefAddr("UserName", this.userName));
        ref.add(5, new StringRefAddr("Properties", this.properties));
        ref.add(6, new StringRefAddr("implicitCahingEnabled", Boolean.valueOf(this.implicitCahingEnabled).toString()));
        ref.add(7, new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        ref.add(8, new StringRefAddr("Sql", this.sql));
        ref.add(9, new StringRefAddr("Isolation", this.txIsolation));
        return ref;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setDriverClassName(String driverClassName) throws ClassNotFoundException {
        this.driverClassName = driverClassName;
        Class.forName(driverClassName);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String userName) {
        this.userName = userName;
    }

    public void setProperty(String properties) {
        this.properties = properties;
    }

    public void setImplicitCachingEnabled(boolean b) throws SQLException {
        this.implicitCahingEnabled = b;
    }

    public void setMaxStatements(int i) throws SQLException {
        this.maxStatements = i;
    }

    public void setQuery(String sql) {
        this.sql = sql;
    }

    public void setTransactionIsolation(String txIsolation) {
        this.txIsolation = txIsolation;
    }
}

