/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import com.sybase.jdbc2.jdbc.SybSQLException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JEUSConnectionChecker;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.xa.JDBCXAResourceWrapper;
import jeus.transaction.TMCommonService;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TxHelper;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.JDBCDriverChecker;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class LogicalConnectionPreparerImpl {
    private final ConnectionPoolImpl connectionPool;
    private final ConnectionPoolInfo poolInfo;
    private final JEUSConnectionChecker connectionChecker;
    private TransactionManager txManager;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public LogicalConnectionPreparerImpl(ConnectionPoolImpl connectionPool) throws SQLException {
        this.connectionPool = connectionPool;
        this.poolInfo = connectionPool.getConnectionPoolInfo();
        this.txManager = TxHelper.getTransactionManager();
        if (this.poolInfo.isCheckQuery()) {
            try {
                Class<?> checkQueryClass = Class.forName(this.poolInfo.getCheckQueryClassName());
                this.connectionChecker = (JEUSConnectionChecker)checkQueryClass.newInstance();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        } else {
            this.connectionChecker = null;
        }
    }

    public void prepareConnectionHandle(JeusPooledConnection pcon, ConnectionPoolImpl pool) throws SQLException {
        Connection handle = pcon.getActualHandle();
        int poolType = this.poolInfo.getPoolType();
        if (poolType == 1) {
            if (this.poolInfo.isUseAutoCommit()) {
                this.setAutoCommit(handle, this.poolInfo.isAutoCommit());
            }
        } else if (poolType == 3) {
            if (TMCommonService.isAssociatedWithTransaction()) {
                this.setAutoCommit(handle, false);
            } else if (this.poolInfo.isUseAutoCommit()) {
                this.setAutoCommit(handle, this.poolInfo.isAutoCommit());
            }
        } else if (poolType == 2) {
            if (!TMCommonService.isAssociatedWithTransaction()) {
                if (this.poolInfo.isUseAutoCommit()) {
                    this.setAutoCommit(handle, this.poolInfo.isAutoCommit());
                }
            } else {
                this.enlistXAResource(pcon, pool);
            }
        } else {
            throw new RuntimeException("Unknown Type of DataSource");
        }
        this.checkConnection(handle, pcon);
    }

    private void setAutoCommit(Connection handle, boolean autoCommit) throws SQLException {
        try {
            handle.setAutoCommit(autoCommit);
        }
        catch (SQLException sqle) {
            try {
                if (!(this.poolInfo.getDBMSType().equals(DBMSType.SYBASE) || JDBCDriverChecker.checkDriverLoaded("com.sybase.jdbc2.jdbc.SybSQLException") && sqle instanceof SybSQLException)) {
                    throw sqle;
                }
                handle.commit();
                handle.setAutoCommit(autoCommit);
            }
            catch (SQLException e) {
                throw sqle;
            }
        }
    }

    public void prepareRawXAConnection(JeusPooledConnection pcon, ConnectionPoolImpl pool) throws SQLException {
        Connection handle = pcon.getActualHandle();
        this.checkConnection(handle, pcon);
    }

    private XAResource enlistXAResource(JeusPooledConnection pcon, ConnectionPoolImpl pool) throws SQLException {
        try {
            TransactionImpl tx = (TransactionImpl)this.txManager.getTransaction();
            if (tx == null) {
                return null;
            }
            JDBCXAResourceWrapper rsc = new JDBCXAResourceWrapper(pool, pcon.getXAResource());
            rsc.setXAResourceFactory(new JEUSXAResourceFactory(pool.getReference()));
            pcon.setXaResourceWrapper(rsc);
            tx.enlistResource(rsc);
            if (logger.isLoggable(JeusMessage_JDBC._9_LEVEL)) {
                logger.log(JeusMessage_JDBC._9_LEVEL, JeusMessage_JDBC._9, (Object[])new String[]{this.poolInfo.getExportName(), tx.getGTID().toString()});
            }
            return rsc;
        }
        catch (Throwable ex) {
            logger.logp(JeusMessage_JDBC._10_LEVEL, "ConnectionPool", "enlistXAResource", JeusMessage_JDBC._10, (Object)this.poolInfo.getExportName());
            throw new JeusSQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._10, (Object)this.poolInfo.getExportName()), ex);
        }
    }

    private void delistXAResource(XAResource rsc, int flag) {
        try {
            Transaction tx = this.txManager.getTransaction();
            if (tx == null) {
                return;
            }
            tx.delistResource(rsc, flag);
            if (logger.isLoggable(JeusMessage_JDBC._12_LEVEL)) {
                logger.log(JeusMessage_JDBC._12_LEVEL, JeusMessage_JDBC._12, (Object[])new String[]{this.poolInfo.getExportName(), ((TransactionImpl)tx).getGTID().toString()});
            }
        }
        catch (Throwable ex) {
            logger.logp(JeusMessage_JDBC._13_LEVEL, "ConnectionPool", "delistXAResource", JeusMessage_JDBC._13, (Object)this.poolInfo.getExportName(), ex);
        }
    }

    public void stripConnectionHandleResource(JeusPooledConnection con, boolean abnormalClose) {
        XAResourceWrapper rsc = con.getXaResourceWrapper();
        if (rsc != null && rsc.inTx()) {
            int txCode = abnormalClose ? 0x20000000 : 0x4000000;
            this.delistXAResource(rsc, txCode);
            con.setXaResourceWrapper(null);
        }
    }

    private void checkConnection(Connection handle, JeusPooledConnection pcon) throws SQLException {
        String checkQuery;
        if (!this.poolInfo.isCheckQuery()) {
            return;
        }
        long interval = this.poolInfo.getNonValidationInterval();
        if (interval > 0L) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - pcon.getLastValidTime() < interval) {
                if (logger.isLoggable(JeusMessage_JDBC._349_LEVEL)) {
                    logger.log(JeusMessage_JDBC._349_LEVEL, JeusMessage_JDBC._349, (Object)pcon);
                }
                return;
            }
            pcon.setLastValidTime(currentTime);
        }
        if (logger.isLoggable(JeusMessage_JDBC._312_LEVEL)) {
            logger.log(JeusMessage_JDBC._312_LEVEL, JeusMessage_JDBC._312, new Object[]{this.poolInfo.getCheckQuery(), pcon});
        }
        if ((checkQuery = this.poolInfo.getCheckQuery()) != null && !checkQuery.equals("")) {
            this.connectionChecker.setQueryString(checkQuery);
        }
        this.connectionChecker.checkConnection(handle);
    }
}

