/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class PeriodicConnectionChecker
extends ScheduleTask {
    private static final ScheduledExecutor executor = ScheduledExecutor.getInstance();
    private final long period;
    private final ConnectionPoolImpl pool;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public PeriodicConnectionChecker(long period, ConnectionPoolImpl pool) throws RuntimeException {
        if (period <= 0L) {
            throw new RuntimeException("Period should be bigger than zero.");
        }
        this.period = period;
        this.pool = pool;
    }

    public void startPeriodicChecker() {
        executor.scheduleWithFixedDelay(this, this.period, this.period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (logger.isLoggable(JeusMessage_JDBC._339_LEVEL)) {
                logger.logp(JeusMessage_JDBC._339_LEVEL, "ConnectionPool", "checkConnection", JeusMessage_JDBC._339, (Object)this.pool.getExportName());
            }
            if (this.pool.isFailed()) {
                JeusPooledConnection pcon = this.pool.createNewPooledConnection();
                this.pool.returnPooledConnectionDirectly(pcon);
                if (logger.isLoggable(JeusMessage_JDBC._306_LEVEL)) {
                    logger.log(JeusMessage_JDBC._306_LEVEL, JeusMessage_JDBC._306, new Object[]{this.pool.getExportName()});
                }
                this.pool.changeFailedState(true, false);
                return;
            }
            int connections = this.pool.getPoolSize();
            for (int i = 0; i < connections; ++i) {
                Connection con = null;
                try {
                    con = this.pool.getConnectionToCheck();
                    if (con != null) continue;
                    logger.log(Level.FINE, "Periodic connection check finished : " + this.pool.getExportName());
                    return;
                }
                finally {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException e) {}
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.cancel();
    }
}

