/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public final class JDBCLocalXAResourceWrapper
extends LocalXAResourceWrapper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private ConnectionPool connectionPool;
    private JeusPooledConnection jeusPooledConn;

    public JeusPooledConnection getJeusPooledConnection() {
        return this.jeusPooledConn;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public JDBCLocalXAResourceWrapper(JeusPooledConnection jeusPooledConn, ConnectionPool connectionpool) {
        this.jeusPooledConn = jeusPooledConn;
        this.connectionPool = connectionpool;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!onePhase) {
            if (logger.isLoggable(JeusMessage_JDBC._23_LEVEL)) {
                logger.logp(JeusMessage_JDBC._23_LEVEL, "JDBCLocalXAResourceWrapper", "commit", JeusMessage_JDBC._23);
            }
            throw new JeusXAException(JeusMessage_JDBC._23);
        }
        try {
            this.jeusPooledConn.commitConnectionHandle();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._24_LEVEL)) {
                logger.logp(JeusMessage_JDBC._24_LEVEL, "JDBCLocalXAResourceWrapper", "commit", JeusMessage_JDBC._24, (Object)t.toString(), t);
            }
            throw new JeusXAException(JeusMessage_JDBC._24, t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.jeusPooledConn.rollbackConnectionHandle();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._32_LEVEL)) {
                logger.logp(JeusMessage_JDBC._32_LEVEL, "JDBCLocalXAResourceWrapper", "rollback", JeusMessage_JDBC._32);
            }
            throw new JeusXAException(JeusMessage_JDBC._32, t);
        }
    }

    public void enforceEnd() {
    }

    public String getName() {
        if (this.connectionPool != null) {
            return this.connectionPool.getExportName();
        }
        return null;
    }
}

