/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.xa;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.common.MetadataWrapper;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.jdbc.connectionpool.JDBCResource;
import jeus.jdbc.stmt.CallableStatementWrapper;
import jeus.jdbc.stmt.PreparedStatementWrapper;
import jeus.jdbc.stmt.StatementWrapper;
import jeus.util.properties.JeusJDBCProperties;
import jeus.util.trace.ManagedResource;

public class LocalXAConnectionWrapper
implements JeusConnection {
    private Connection actualConn;
    private boolean isClosed;
    private boolean isLogicalConnectionClosed;
    private ConnectionPool connectionPool;
    private JeusPooledConnection pooledConn;
    private JDBCResource managedResource;
    private volatile int referenceCount = 1;

    public LocalXAConnectionWrapper(Connection con, JeusPooledConnection pCon, ConnectionPool connectionPool) {
        this.actualConn = con;
        this.connectionPool = connectionPool;
        this.pooledConn = pCon;
    }

    public Statement createStatement() throws SQLException {
        this.checkLogicalConnectionOpen();
        Statement statement = this.actualConn.createStatement();
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new StatementWrapper(this, statement) : statement;
    }

    private void checkLogicalConnectionOpen() throws SQLException {
        if (this.isLogicalConnectionClosed) {
            throw new SQLException("This local XA connection was already closed when transaction created by that connection had been completed.");
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkLogicalConnectionOpen();
        CallableStatement callableStatement = this.actualConn.prepareCall(sql);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new CallableStatementWrapper(this, callableStatement) : callableStatement;
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.commit();
    }

    public void rollback() throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.rollback();
    }

    public void close() throws SQLException {
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkLogicalConnectionOpen();
        return new MetadataWrapper(this, this.actualConn.getMetaData());
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkLogicalConnectionOpen();
        Statement statement = this.actualConn.createStatement(resultSetType, resultSetConcurrency);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new StatementWrapper(this, statement) : statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkLogicalConnectionOpen();
        CallableStatement callableStatement = this.actualConn.prepareCall(sql, resultSetType, resultSetConcurrency);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new CallableStatementWrapper(this, callableStatement) : callableStatement;
    }

    public Map getTypeMap() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkLogicalConnectionOpen();
        return this.actualConn.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkLogicalConnectionOpen();
        this.actualConn.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkLogicalConnectionOpen();
        Statement statement = this.actualConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new StatementWrapper(this, statement) : statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkLogicalConnectionOpen();
        CallableStatement callableStatement = this.actualConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new CallableStatementWrapper(this, callableStatement) : callableStatement;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql, autoGeneratedKeys);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql, columnIndexes);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkLogicalConnectionOpen();
        PreparedStatement preparedStatement = this.actualConn.prepareStatement(sql, columnNames);
        return JeusJDBCProperties.USE_STATEMENT_WRAPPER ? new PreparedStatementWrapper(this, preparedStatement) : preparedStatement;
    }

    public void forceClose() {
        this.isLogicalConnectionClosed = true;
        try {
            this.actualConn.close();
            this.connectionPool.connectionClosed(this.pooledConn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ManagedResource getManagedResource() {
        return this.managedResource;
    }

    public void setDefaultRowPrefetch(int i) {
    }

    public String getConnectionId() {
        return null;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void incrementReference() {
        ++this.referenceCount;
    }

    public int decrementReferenceAndGet() {
        return --this.referenceCount;
    }
}

