/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import jeus.jndi.JEUSClusterContext;
import jeus.jndi.JEUSFailoverContext;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.delegate.JEUSRemoteContext;
import jeus.jndi.jns.delegate.JEUSRemoteDirContext;
import jeus.jndi.jns.delegate.RemoteContext;
import jeus.jndi.jns.delegate.RemoteContextFactory;
import jeus.jndi.jns.delegate.RemoteDirContext;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.util.StringUtil;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.client.TMClient;
import jeus.util.ExecutionContext;
import jeus.util.JeusPort;
import jeus.util.SecurityUtil;
import jeus.util.VirtualDNS;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusTMProperties;

public class JNSContextFactory
implements InitialContextFactory,
ObjectFactory {
    private static Hashtable dnsTable = new Hashtable();

    public Context getInitialContext(Hashtable table) throws NamingException {
        String fullServerName = (String)table.get("java.naming.provider.url");
        if (fullServerName == null || fullServerName.lastIndexOf(",") == -1) {
            if (fullServerName == null) {
                fullServerName = "localhost";
            }
            return new JEUSFailoverContext(new String[]{fullServerName}, table);
        }
        return this.makeClusterContext(fullServerName, table);
    }

    private Context makeClusterContext(String fullServerName, Hashtable table) throws NamingException {
        ArrayList<String> allLinks = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(fullServerName, ",");
        while (token.hasMoreTokens()) {
            allLinks.add(token.nextToken().trim());
        }
        return new JEUSClusterContext(allLinks.toArray(new String[allLinks.size()]), table);
    }

    public static Context getInternalInitialContext(Hashtable table) throws NamingException {
        String serverName;
        if (table == null) {
            table = new Hashtable();
        }
        JNSContextFactory.addNamingProperties(table);
        Map map = (Map)ExecutionContext.getFromContextStacks("JNDI_PROPERTIES");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (table.containsKey(key)) continue;
                table.put(key, entry.getValue());
            }
        }
        boolean enableDelegate = JNSContextFactory.checkContextDelegate(table);
        int jbaseport = JeusPort.JeusBase;
        if (table.get("java.naming.factory.initial") == null) {
            table.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        }
        if (table.get("java.naming.provider.url") != null) {
            serverName = (String)table.get("java.naming.provider.url");
            if (serverName.lastIndexOf(":") == -1) {
                serverName = VirtualDNS.getRealNodeName(serverName);
            }
            int index = serverName.lastIndexOf(":");
            jbaseport = Integer.parseInt(serverName.substring(index + 1));
            serverName = serverName.substring(0, index);
            table.put("java.naming.provider.url", serverName + ":" + jbaseport);
        } else {
            table.put("java.naming.provider.url", "127.0.0.1");
            serverName = "127.0.0.1";
        }
        if (table.get("java.naming.factory.url.pkgs") == null) {
            table.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
        }
        boolean isLogin = false;
        try {
            Subject loginSubject = LoginService.getCurrentSubject();
            Object credential = table.get("java.naming.security.credentials");
            if (loginSubject == null || loginSubject instanceof AnonymousSubject) {
                SecurityUtil.installClientSecurity(serverName + ":" + jbaseport);
                String username = (String)table.get("java.naming.security.principal");
                if (credential instanceof X509Certificate) {
                    loginSubject = new Subject(null, null);
                    loginSubject.getPublicCredentials().add(credential);
                    LoginUtil.loginWithRuntimeException(loginSubject);
                    isLogin = true;
                } else if (username != null && credential != null) {
                    loginSubject = Subject.makeSubject(username, (String)credential);
                    LoginUtil.loginWithRuntimeException(loginSubject);
                    isLogin = true;
                }
            } else {
                String username = (String)table.get("java.naming.security.principal");
                if (credential instanceof X509Certificate) {
                    loginSubject = new Subject(null, null);
                    loginSubject.getPrivateCredentials().add(credential);
                } else if (username != null && credential != null) {
                    loginSubject = Subject.makeSubject(username, (String)credential);
                }
            }
            table.put("jeus.jndi.jns.loginsubject", loginSubject);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new NamingException(e.toString());
        }
        JNSContextFactory.initTM();
        if (enableDelegate && table.get("jeus.jndi.delegate.environment") != null) {
            return JNSContextFactory.makeRemoteContext(serverName, table);
        }
        return JNSContextFactory.makeContext(table, isLogin);
    }

    private static Context makeContext(Hashtable table, boolean login) throws NamingException {
        try {
            JNSContext context = new JNSContext(JNSLocal.getLocalServer(table), table, "");
            if (login) {
                context.enableLogoutClose();
            }
            return context;
        }
        catch (Exception e) {
            NamingException ex = new NamingException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Context makeRemoteContext(String serverName, Hashtable table) throws NamingException {
        try {
            String hostname = serverName;
            if (serverName.equals("127.0.0.1") || serverName.equals("localhost") || serverName.equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS)) {
                hostname = JeusNetPropertyValues.LOCAL_HOSTNAME;
            } else if (!serverName.equals(JeusNetPropertyValues.LOCAL_HOSTNAME)) {
                Object _hostname = dnsTable.get(serverName);
                if (_hostname == null) {
                    Hashtable hashtable = dnsTable;
                    synchronized (hashtable) {
                        _hostname = dnsTable.get(serverName);
                        if (_hostname == null) {
                            _hostname = JeusNetPropertyValues.getByName((String)serverName).getHostName();
                            dnsTable.put(serverName, _hostname);
                        }
                    }
                }
                hostname = (String)_hostname;
            }
            JNSContext ctx = new JNSContext(JNSLocal.getLocalServer(table), table, "");
            RemoteContextFactory factory = (RemoteContextFactory)ctx.lookup("_" + hostname + "_jeus_RemoteContextFactory");
            RemoteContext rtCtx = factory.getContext(table);
            if (rtCtx instanceof RemoteDirContext) {
                return new JEUSRemoteDirContext((RemoteDirContext)rtCtx);
            }
            return new JEUSRemoteContext(rtCtx);
        }
        catch (Throwable t) {
            throw new NamingException(t.toString());
        }
    }

    protected static void initTM() throws NamingException {
        try {
            if (TMServer.isInitialized() || TMClient.initialized) {
                return;
            }
            if (!JeusTMProperties.NOT_USE_TM && JeusPropertyValues.JEUS_CATEGORY == 0) {
                String jeusTmVersion = JeusTMProperties.TM_VERSION;
                if ("server".equals(jeusTmVersion)) {
                    TMServer.init(null, false);
                } else {
                    TMClient.init(null);
                }
            }
        }
        catch (TMException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pr = new PrintWriter(sw);
            e.printStackTrace(pr);
            throw new NamingException(e.toString() + " : " + sw.toString());
        }
    }

    private static boolean checkContextDelegate(Hashtable table) {
        boolean enableDelegate = false;
        String value = (String)table.get("jeus.jndi.delegate.enable");
        if (value != null && !value.equals("")) {
            enableDelegate = Boolean.valueOf(value);
        }
        if (enableDelegate && table.get("jeus.jndi.delegate.environment") == null) {
            Hashtable delegate = new Hashtable();
            int skipLength = "jeus.jndi.delegate".length() + 1;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String prefix = (String)keys.nextElement();
                if (!prefix.startsWith("jeus.jndi.delegate")) continue;
                delegate.put(prefix.substring(skipLength), table.get(prefix));
            }
            if (delegate.size() > 0) {
                table.put("jeus.jndi.delegate.environment", delegate);
            }
        }
        return enableDelegate;
    }

    private static void addNamingProperties(Hashtable table) {
        try {
            Properties prop = System.getProperties();
            Enumeration<?> names = prop.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!StringUtil.isNamingProperty(name) || table.get(name) != null) continue;
                table.put(name, prop.getProperty(name));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (JNS.isJNSContext(obj)) {
            Reference ref = (Reference)obj;
            RefAddr bindingEnvAddr = ref.get(0);
            int bindingEnvValue = Integer.parseInt((String)bindingEnvAddr.getContent());
            String nameInNamespace = (String)ref.get(1).getContent();
            return new JNSContext(JNSLocal.getLocalServer(environment), environment, bindingEnvValue, nameInNamespace, null);
        }
        return null;
    }
}

