/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.common;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import jeus.jndi.JEUSContextFactory;
import jeus.util.JeusPort;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSCommon;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusNetPropertyValues;

public class ClusterManager
extends ScheduleTask {
    private static final HashMap failList = new HashMap();
    private static ScheduleTask timerTask;
    private static final JeusLogger logger;
    private static final Set failedLinkSet;
    private static final ThreadLocal isInClustering;

    public static synchronized void addCluster(String serverName) {
        serverName = ClusterManager.checkServerName(serverName);
        failList.remove(serverName);
        if (logger.isLoggable(JeusMessage_JNSCommon._1_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._1_LEVEL, JeusMessage_JNSCommon._1, new Object[]{serverName, failList});
        }
        if (failList.size() == 0 && timerTask != null) {
            if (logger.isLoggable(JeusMessage_JNSCommon._2_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._2_LEVEL, JeusMessage_JNSCommon._2);
            }
            timerTask.cancel();
            timerTask = null;
        }
    }

    private static String checkServerName(String serverName) {
        String port;
        int portIndex = serverName.indexOf(58);
        if (portIndex < 0) {
            port = String.valueOf(JeusPort.JeusBase);
        } else {
            port = serverName.substring(portIndex + 1);
            serverName = serverName.substring(0, portIndex);
        }
        try {
            serverName = JeusNetPropertyValues.getByName((String)serverName).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        serverName = serverName + ":" + port;
        return serverName;
    }

    public static synchronized boolean isInFailList(String serverName) {
        serverName = ClusterManager.checkServerName(serverName);
        boolean result = failList.containsKey(serverName);
        if (logger.isLoggable(JeusMessage_JNSCommon._3_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._3_LEVEL, JeusMessage_JNSCommon._3, new Object[]{serverName, failList, ClusterManager.class.getClassLoader()});
        }
        return result;
    }

    public static synchronized void addFailList(String serverName) {
        serverName = ClusterManager.checkServerName(serverName);
        int prevSize = failList.size();
        failList.put(serverName, serverName);
        if (logger.isLoggable(JeusMessage_JNSCommon._4_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._4_LEVEL, JeusMessage_JNSCommon._4, new Object[]{serverName, failList});
        }
        if (prevSize == 0 && timerTask == null) {
            if (logger.isLoggable(JeusMessage_JNSCommon._5_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._5_LEVEL, JeusMessage_JNSCommon._5);
            }
            timerTask = new ClusterManager();
            ScheduledExecutor.getInstance().schedule(timerTask, JeusJNDIProperties.CLUSTER_RECHECK_PERIOD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Class<ClusterManager> clazz = ClusterManager.class;
            synchronized (ClusterManager.class) {
                String[] failServerNames = failList.keySet().toArray(new String[0]);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (int i = 0; i < failServerNames.length; ++i) {
                    String failServerName = failServerNames[i];
                    ClusterManager.checkFailNode(failServerName);
                }
                Class<ClusterManager> clazz2 = ClusterManager.class;
                synchronized (ClusterManager.class) {
                    if (failList.size() > 0) {
                        timerTask = new ClusterManager();
                        ScheduledExecutor.getInstance().schedule(timerTask, JeusJNDIProperties.CLUSTER_RECHECK_PERIOD);
                    } else {
                        if (logger.isLoggable(JeusMessage_JNSCommon._6_LEVEL)) {
                            logger.log(JeusMessage_JNSCommon._6_LEVEL, JeusMessage_JNSCommon._6);
                        }
                        timerTask = null;
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFailNode(String failServerName) {
        if (!ClusterManager.isInFailList(failServerName = ClusterManager.checkServerName(failServerName))) {
            return true;
        }
        failList.remove(failServerName);
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.provider.url", failServerName);
        try {
            JEUSContextFactory.getInternalInitialContext(table);
            Class<ClusterManager> clazz = ClusterManager.class;
            synchronized (ClusterManager.class) {
                ClusterManager.addCluster(failServerName);
                if (logger.isLoggable(JeusMessage_JNSCommon._8_LEVEL)) {
                    logger.log(JeusMessage_JNSCommon._8_LEVEL, JeusMessage_JNSCommon._8, new Object[]{failServerName, failList});
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }
        catch (NamingException e) {
            failList.put(failServerName, failServerName);
            if (logger.isLoggable(JeusMessage_JNSCommon._9_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._9_LEVEL, JeusMessage_JNSCommon._9, (Object)failServerName, (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFailNodes() {
        Class<ClusterManager> clazz = ClusterManager.class;
        synchronized (ClusterManager.class) {
            String[] failServerNames = failList.keySet().toArray(new String[0]);
            // ** MonitorExit[var1] (shouldn't be in output)
            return ClusterManager.checkFailNodes(failServerNames);
        }
    }

    public static boolean checkFailNodes(String[] failServerNames) {
        for (int i = 0; i < failServerNames.length; ++i) {
            String failServerName = failServerNames[i];
            if (!ClusterManager.checkFailNode(failServerName)) continue;
            return true;
        }
        return false;
    }

    public static int failListSize() {
        return failList.size();
    }

    public static synchronized String[] getFailList() {
        return failList.keySet().toArray(new String[0]);
    }

    public static void addFailedLink(String link) {
        failedLinkSet.add(link);
    }

    public static void removeFailedLink(String link) {
        failedLinkSet.remove(link);
    }

    public static boolean isFailedLink(String link) {
        return failedLinkSet.contains(link);
    }

    public static boolean startClustering() {
        if (isInClustering.get() != null) {
            return false;
        }
        isInClustering.set(isInClustering);
        return true;
    }

    public static void endClustering() {
        isInClustering.set(null);
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi.cluster");
        failedLinkSet = Collections.synchronizedSet(new HashSet());
        isInClustering = new ThreadLocal();
    }
}

