/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.common;

import java.io.Serializable;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JNSCode;

public class Message
implements Serializable {
    static final long serialVersionUID = 2458717259141528065L;
    private int opcode;
    private int envValue;
    private Object[] items = new Object[2];
    private transient Environment env;

    public Message() {
    }

    public Message(int opcode, Environment env) {
        this.opcode = opcode;
        this.envValue = env == null ? -1 : env.toInt();
    }

    public Message(int opcode, Environment env, Object obj1, Object obj2) {
        this(opcode, env == null ? Environment.defaultEnvValue : env.toInt(), obj1, obj2);
    }

    public Message(int opcode, int env, Object obj1, Object obj2) {
        this.opcode = opcode;
        this.envValue = env;
        if (obj1 != null) {
            this.items[0] = obj1;
        }
        if (obj2 != null) {
            this.items[1] = obj2;
        }
    }

    public void put(int index, Object value) {
        if (value != null) {
            if (this.items.length < index) {
                Object[] temp = new Object[index + 1];
                System.arraycopy(this.items, 0, temp, 0, this.items.length);
                this.items = temp;
            }
            this.items[index] = value;
        }
    }

    public Object get(int index) {
        if (this.items.length <= index) {
            return null;
        }
        return this.items[index];
    }

    public int getCode() {
        return this.opcode;
    }

    public Environment getEnvironment() {
        if (this.env == null) {
            this.env = this.envValue == -1 ? Environment.defaultEnv : new Environment(this.envValue);
        }
        return this.env;
    }

    public void setCode(int opcode) {
        this.opcode = opcode;
    }

    public int getType() {
        if (this.opcode >= 201 && this.opcode < 301) {
            return 1;
        }
        if (this.opcode >= 301 && this.opcode < 401) {
            return 2;
        }
        if (this.opcode >= 401 && this.opcode < 405) {
            return 3;
        }
        if (this.opcode == 405) {
            return 405;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(JNSCode.getString(this.opcode)).append(",");
        sb.append(new Environment(this.envValue)).append(",");
        for (int i = 0; i < this.items.length; ++i) {
            sb.append("item").append(i).append('(').append(this.items[i]).append("),");
        }
        sb.append(")");
        return sb.toString();
    }
}

