/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.delegate;

import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import jeus.jndi.jns.delegate.JEUSNamingManager;
import jeus.jndi.jns.delegate.RemoteContext;
import jeus.jndi.jns.delegate.RemoteContextFactory;
import jeus.util.properties.JeusManagerPropertyValues;

public class RemoteContextFactoryImpl
implements RemoteContextFactory {
    public void export(String hostname) throws NamingException {
        try {
            UnicastRemoteObject.exportObject((Remote)this, JeusManagerPropertyValues.getDefaultRMIPort());
            InitialContext ctx = new InitialContext();
            ctx.rebind("_" + hostname + "_jeus_RemoteContextFactory", (Object)this);
        }
        catch (Throwable te) {
            te.printStackTrace();
            throw new NamingException(te.toString());
        }
    }

    public void unexport(String hostname) throws NamingException {
        try {
            UnicastRemoteObject.unexportObject(this, true);
            InitialContext ctx = new InitialContext();
            ctx.unbind("_" + hostname + "_jeus_RemoteContextFactory");
        }
        catch (Throwable te) {
            te.printStackTrace();
            throw new NamingException(te.toString());
        }
    }

    public RemoteContext getContext(Hashtable env) throws NamingException {
        Context context;
        Hashtable delegate = null;
        try {
            if (env != null) {
                delegate = (Hashtable)env.get("jeus.jndi.delegate.environment");
            }
        }
        catch (ClassCastException ex) {
            throw new NoInitialContextException("Property jeus.jndi.delegate.environment (" + env.get("jeus.jndi.delegate.environment") + ") " + "is not an instance of Hashtable");
        }
        if (delegate == null) {
            context = null;
        } else {
            InitialContextFactory initialcontextfactory;
            String factory = (String)delegate.get("java.naming.factory.initial");
            if (factory == null) {
                throw new NoInitialContextException("Property jeus.jndi.delegate.environment.java.naming.factory.initial is null");
            }
            try {
                initialcontextfactory = (InitialContextFactory)Class.forName(factory).newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new NoInitialContextException("Failed to find jeus.jndi.delegate.environment.java.naming.factory.initial (" + factory + ") " + "on server");
            }
            catch (ClassCastException ex) {
                throw new NoInitialContextException("Class specified by jeus.jndi.delegate.environment.java.naming.factory.initial (" + factory + ") " + "does not implement InitialContextFactory");
            }
            catch (Exception ex) {
                NoInitialContextException exception = new NoInitialContextException("Failed to instantiate jeus.jndi.delegate.environment.java.naming.factory.initial (" + factory + ") " + "on server");
                exception.setRootCause(ex);
                throw exception;
            }
            context = initialcontextfactory.getInitialContext(delegate);
        }
        return (RemoteContext)JEUSNamingManager.getTransportableInstance(context, null, null, delegate);
    }
}

