/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.jndi.io.JndiContentHandlerCreator;
import jeus.jndi.jns.common.ClusterManager;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NamingServerException;
import jeus.jndi.jns.local.DirService;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSLocal;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusNodeClusterProperties;

public class JNSLocal
extends JNS
implements ConnectionListener {
    private DirService dirService;
    NodeInfo localServerID;
    private AtomicBoolean running = new AtomicBoolean();
    private static final Map localServerTable = new Hashtable();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi");
    private static Endpoint connector;
    private SocketStream sockStream;
    private static Set clusterInfoTable;
    private static boolean invalidClusterInfo;
    private static String clusterUrl;
    private boolean enableCache = true;
    private int connectTimeout;
    private int socketReadTimeout;
    public static final int JNDI_PROTOCOL_VERSION = 1;

    private JNSLocal(NodeInfo nodeInfo, Hashtable table) throws NamingServerException {
        this.localServerID = nodeInfo;
        if (table != null) {
            String value = (String)table.get("jeus.jndi.enable.cache");
            if ("false".equalsIgnoreCase(value)) {
                this.enableCache = false;
            }
            this.connectTimeout = this.getTimeout(table, "jeus.jndi.jns.connecttimeout");
            this.socketReadTimeout = this.getTimeout(table, "jeus.jndi.jns.connectionduration");
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._40_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._40_LEVEL, JeusMessage_JNSLocal._40);
        }
    }

    private int getTimeout(Hashtable table, String key) throws NamingServerException {
        String value = (String)table.get(key);
        if (value == null) {
            return 0;
        }
        try {
            int timeout = Integer.parseInt(value);
            if (timeout < 0) {
                throw new NamingServerException(key + " cannot be negative");
            }
            return timeout;
        }
        catch (NumberFormatException e) {
            throw new NamingServerException("invalid value " + value + " for " + key);
        }
    }

    public DirService getDirService() {
        return this.dirService;
    }

    public static JNSLocal getLocalServer() throws NamingServerException {
        NodeInfo nodeInfo = JeusJNDIProperties.USE_SSL ? new NodeInfo("127.0.0.1", JeusPort.JNDI_SSL, 0) : new NodeInfo("127.0.0.1", JeusPort.JeusBase, "JNSServer", 0);
        return JNSLocal.getLocalServer(nodeInfo, null);
    }

    public static JNSLocal getLocalServer(Hashtable table) throws NamingServerException, UnknownHostException {
        String hostname;
        int baseport;
        int n = baseport = JeusJNDIProperties.USE_SSL ? JeusPort.JNDI_SSL : JeusPort.JeusBase;
        if (table.containsKey("java.naming.provider.url")) {
            hostname = (String)table.get("java.naming.provider.url");
            int index = hostname.indexOf(":");
            if (index > 0) {
                baseport = Integer.parseInt(hostname.substring(index + 1));
                hostname = hostname.substring(0, index);
            }
            if ((hostname = JeusNetPropertyValues.getByName((String)hostname).getHostAddress()).equals("localhost") || hostname.equals(JeusNetPropertyValues.LOCAL_HOSTNAME) || hostname.equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS) || hostname.equals(JeusNetPropertyValues.LOCAL_FULL_HOSTNAME)) {
                hostname = "127.0.0.1";
            }
        } else {
            hostname = "127.0.0.1";
        }
        NodeInfo nodeInfo = JeusJNDIProperties.USE_SSL ? new NodeInfo(hostname, baseport, 0) : new NodeInfo(hostname, baseport, "JNSServer", 0);
        return JNSLocal.getLocalServer(nodeInfo, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNSLocal getLocalServer(NodeInfo nodeInfo, Hashtable table) throws NamingServerException {
        JNSLocal localServer;
        Map map = localServerTable;
        synchronized (map) {
            localServer = (JNSLocal)localServerTable.get(nodeInfo);
            if (localServer == null) {
                if (ClusterManager.isInFailList(nodeInfo.getHost() + ":" + nodeInfo.getBasePort())) {
                    throw new NamingServerException("The JNSServer is in fail list : " + nodeInfo);
                }
                localServer = new JNSLocal(nodeInfo, table);
                localServerTable.put(nodeInfo, localServer);
                localServer.startup();
            }
        }
        return localServer;
    }

    protected void startup() throws NamingServerException {
        this.running.set(true);
        if (logger.isLoggable(JeusMessage_JNSLocal._4_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._4_LEVEL, JeusMessage_JNSLocal._4);
        }
        try {
            this.dirService = new DirService(this, this.enableCache);
            this.sockStream = connector.getSocketStream((SocketID)this.localServerID, JeusNodeClusterProperties.TERMINAL_CLUSTERING_RETRY_COUNT, (Object)new Integer(1), this.connectTimeout, this.socketReadTimeout);
            if (logger.isLoggable(JeusMessage_JNSLocal._5_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._5_LEVEL, JeusMessage_JNSLocal._5, (Object)this.localServerID);
            }
        }
        catch (Exception e) {
            logger.logp(JeusMessage_JNSLocal._6_LEVEL, "JNSLocal", "startup", JeusMessage_JNSLocal._6, (Throwable)e);
            this.cancel();
            throw new NamingServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSLocal._18));
        }
    }

    public static void down() {
        JNSLocal[] locals = localServerTable.values().toArray(new JNSLocal[0]);
        for (int i = 0; i < locals.length; ++i) {
            JNSLocal local = locals[i];
            local.cancel();
        }
    }

    public static synchronized void down(String serverName) {
        NodeInfo nodeInfo;
        String url = serverName;
        int index = serverName.indexOf(":");
        if (index == -1) {
            if (url.equals("localhost") || url.equals(JeusNetPropertyValues.LOCAL_HOSTNAME) || url.equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS) || url.equals(JeusNetPropertyValues.LOCAL_FULL_HOSTNAME)) {
                url = "127.0.0.1";
            }
            nodeInfo = new NodeInfo(url, JeusPort.JeusBase, String.valueOf("JNSServer"), 0);
        } else {
            int baseport = Integer.parseInt(url.substring(index + 1));
            if ((url = url.substring(0, index)).equals("localhost") || url.equals(JeusNetPropertyValues.LOCAL_HOSTNAME) || url.equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS) || url.equals(JeusNetPropertyValues.LOCAL_FULL_HOSTNAME)) {
                url = "127.0.0.1";
            }
            nodeInfo = new NodeInfo(url, baseport, String.valueOf("JNSServer"), 0);
        }
        JNSLocal jnsLocal = (JNSLocal)localServerTable.remove(nodeInfo);
        if (jnsLocal != null) {
            if (logger.isLoggable(JeusMessage_JNSLocal._7_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._7_LEVEL, JeusMessage_JNSLocal._7, (Object)url);
            }
            jnsLocal.cancel();
        } else if (logger.isLoggable(JeusMessage_JNSLocal._8_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._8_LEVEL, JeusMessage_JNSLocal._8, (Object)url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.running.compareAndSet(true, false)) {
            if (logger.isLoggable(JeusMessage_JNSLocal._9_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._9_LEVEL, JeusMessage_JNSLocal._9);
            }
            if (this.sockStream != null) {
                this.sockStream.destroy();
                this.sockStream = null;
            }
            try {
                if (logger.isLoggable(JeusMessage_JNSLocal._10_LEVEL)) {
                    logger.log(JeusMessage_JNSLocal._10_LEVEL, JeusMessage_JNSLocal._10);
                }
                this.dirService.destroy();
                this.dirService = null;
            }
            catch (Exception e) {
                logger.log(JeusMessage_JNSLocal._11_LEVEL, JeusMessage_JNSLocal._11, (Throwable)e);
            }
            finally {
                localServerTable.remove(this.localServerID);
                if (logger.isLoggable(JeusMessage_JNSLocal._12_LEVEL)) {
                    logger.log(JeusMessage_JNSLocal._12_LEVEL, JeusMessage_JNSLocal._12);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public static JeusLogger getLogger() {
        return logger;
    }

    public void receiveMessage(Object msg, SocketStream sockStream, Object controlInfo) {
        try {
            if (logger.isLoggable(JeusMessage_JNSLocal._41_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._41_LEVEL, JeusMessage_JNSLocal._41, msg);
            }
            this.handle((Message)msg, sockStream);
        }
        catch (Exception e) {
            logger.logp(JeusMessage_JNSLocal._46_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._46, (Throwable)e);
            logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
            logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this.toString());
            sockStream.destroy();
            this.cancel();
        }
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        messageProcessor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream socketStream, int connectionType, Object piggybackedData) {
        clusterInfoTable = (Set)((Object[])piggybackedData)[1];
        invalidClusterInfo = true;
    }

    public void handle(Message msg, SocketStream sockStream) {
        int msgType = msg.getType();
        block3 : switch (msgType) {
            case 3: {
                throw new RuntimeException();
            }
            case 405: {
                try {
                    this.dirService.dispatchEvent(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                int opcode = msg.getCode();
                Object first = msg.get(0);
                Object second = msg.get(1);
                switch (opcode) {
                    case 301: {
                        try {
                            this.dirService.replicate((String)first, second);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block3;
                    }
                    case 303: {
                        try {
                            this.dirService.drop((String)first);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block3;
                    }
                }
                break;
            }
        }
    }

    public SocketStream getSocketStream() {
        if (this.sockStream != null && this.sockStream.isClosed()) {
            this.sockStream = null;
        }
        return this.sockStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Exception exception, SocketStream socketStream) {
        try {
            if (exception != null) {
                if (exception instanceof ClassNotFoundException) {
                    logger.logp(JeusMessage_JNSLocal._42_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._42, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof SocketException) {
                    logger.logp(JeusMessage_JNSLocal._61_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._61, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof EOFException) {
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof IOException) {
                    logger.logp(JeusMessage_JNSLocal._45_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._45, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                    logger.logp(JeusMessage_JNSLocal._63_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._63);
                } else {
                    logger.logp(JeusMessage_JNSLocal._46_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._46, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                }
            }
        }
        finally {
            this.cancel();
        }
    }

    public static synchronized String getClusterInfo() {
        if (JeusNodeClusterProperties.MANAGER_CLUSTERING_URL != null) {
            return JeusNodeClusterProperties.MANAGER_CLUSTERING_URL;
        }
        if (invalidClusterInfo) {
            clusterUrl = null;
            invalidClusterInfo = false;
            Iterator elements = clusterInfoTable.iterator();
            while (elements.hasNext()) {
                if (clusterUrl != null) {
                    clusterUrl = clusterUrl + "," + elements.next();
                    continue;
                }
                clusterUrl = (String)elements.next();
            }
            clusterUrl = clusterUrl != null ? clusterUrl + "," + JeusNetPropertyValues.LOCAL_HOSTADDRESS + ":" + JeusPort.JeusBase : JeusNetPropertyValues.LOCAL_HOSTADDRESS + ":" + JeusPort.JeusBase;
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._64_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._64_LEVEL, JeusMessage_JNSLocal._64, (Object)clusterUrl);
        }
        return clusterUrl;
    }

    public void receiveRequest(Object message, SocketStream socketStream, int skipOffset) {
        this.handle((Message)message, this.sockStream);
    }

    public boolean isSocketStreamDown() {
        return this.sockStream.isClosed();
    }

    static {
        String name = "JNSLocal";
        connector = new Endpoint(name, JeusIOComponentCreator.createSocketBlockingCreator((String)("IO-" + name), (int)0), (SocketID)new NoListenID(), (StreamContentHandlerCreator)new JndiContentHandlerCreator(), new ConnectionListenerFactory(){

            public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
                try {
                    return JNSLocal.getLocalServer((NodeInfo)socketID, null);
                }
                catch (NamingServerException e) {
                    throw new JeusRuntimeException((Throwable)e);
                }
            }
        }, (Object)(JeusJNDIProperties.USE_SSL ? JeusSSLConfiguration.sslContext : null));
        try {
            connector.export();
        }
        catch (IOException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        clusterInfoTable = Collections.EMPTY_SET;
    }
}

