/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server.repository;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JeusNameClassPair;
import jeus.jndi.jns.server.repository.AttrFilter;
import jeus.jndi.jns.server.repository.Leaf;
import jeus.jndi.jns.server.repository.Node;
import jeus.jndi.jns.server.repository.SearchFilter;

public class Composite
extends Node {
    private final Hashtable children = new Hashtable(10);

    public Composite(Composite _parent, String _name, Object _value, Environment _env, Attributes _attrs) {
        super(_parent, _name, _value, _env, _attrs);
    }

    public boolean isComposite() {
        return true;
    }

    public Node find(String _target) {
        if (_target.equals("")) {
            return this;
        }
        Node child = (Node)this.children.get(Composite.getChildName(_target));
        if (child == null) {
            return null;
        }
        return child.find(this.getSubName(_target));
    }

    public void remove() {
        super.remove();
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).remove();
        }
    }

    public Node addComposite(String _target, Object _value, Environment _env, Attributes _attrs) throws NamingException {
        String parentName = this.getParentName(_target);
        Composite pNode = (Composite)this.find(parentName);
        if (pNode == null) {
            throw new NamingException("The context " + parentName + " does not exist");
        }
        return new Composite(pNode, this.getName(_target), _value, _env, _attrs);
    }

    public Node addLeaf(String _target, Object _value, Environment _env, Attributes _attrs) throws NamingException {
        String parentName = this.getParentName(_target);
        Composite pNode = (Composite)this.find(parentName);
        if (pNode == null) {
            throw new NamingException("The context " + parentName + " does not exist");
        }
        return new Leaf(pNode, this.getName(_target), _value, _env, _attrs);
    }

    protected void addChild(Node _child) {
        String name = _child.getName();
        this.children.put(name, _child);
    }

    protected void removeChild(String child) {
        this.children.remove(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        Hashtable hashtable = this.children;
        synchronized (hashtable) {
            Set entries = this.children.entrySet();
            ArrayList<JeusNameClassPair> v = new ArrayList<JeusNameClassPair>(entries.size());
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Object obj = ((Node)entry.getValue()).getValue();
                v.add(new JeusNameClassPair(key, obj.getClass().getName(), obj, false));
            }
            return v;
        }
    }

    public List search(List v, Attributes matchings, String[] attrIds, int level) throws Exception {
        boolean flag;
        if (level > 0) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                ((Node)e.nextElement()).search(v, matchings, attrIds, level - 1);
            }
        }
        if (!(flag = AttrFilter.check(this.attrs, matchings))) {
            return v;
        }
        if (attrIds == null) {
            if (this.attrs == null) {
                this.attrs = new BasicAttributes();
            }
            if (this.value != null) {
                v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, this.attrs));
            } else {
                v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", this.value, this.attrs));
            }
            return v;
        }
        BasicAttributes returnAttrs = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            Attribute attr = this.attrs.get(attrIds[i]);
            if (attr == null) continue;
            returnAttrs.put(attr);
        }
        if (this.value != null) {
            v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, returnAttrs));
        } else {
            v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", this.value, returnAttrs));
        }
        return v;
    }

    public List search(List v, SearchFilter filter, SearchControls cons) throws Exception {
        if (cons.getSearchScope() != 0) {
            if (cons.getSearchScope() == 1) {
                cons.setSearchScope(0);
            }
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                ((Node)e.nextElement()).search(v, filter, cons);
            }
        }
        if (cons.getCountLimit() != 0L && cons.getCountLimit() <= (long)v.size()) {
            return v;
        }
        boolean flag = filter.check(this.attrs);
        if (!flag) {
            return v;
        }
        String[] attrIds = cons.getReturningAttributes();
        if (attrIds == null) {
            if (this.attrs == null) {
                this.attrs = new BasicAttributes();
            }
            if (this.value != null) {
                v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, this.attrs));
            } else {
                v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", this.value, this.attrs));
            }
            return v;
        }
        BasicAttributes returnAttrs = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            returnAttrs.put(this.attrs.get(attrIds[i]));
        }
        flag = cons.getReturningObjFlag();
        if (flag) {
            if (this.value != null) {
                v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, returnAttrs));
            } else {
                v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", this.value, returnAttrs));
            }
        } else if (this.value != null) {
            v.add(new SearchResult(this.name, this.value.getClass().getName(), null, returnAttrs));
        } else {
            v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", null, returnAttrs));
        }
        return v;
    }

    public void print() {
        this.print("");
    }

    public void print(String _tab) {
        System.out.print(_tab + "[" + this.name + "]\n");
        super.print(_tab);
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).print(_tab + "    ");
        }
    }

    public void renameChild(String oldName, String newName) {
        Object child = this.children.remove(oldName);
        this.children.put(newName, child);
    }
}

