/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.analysis;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import jeus.loganalyzer.analysis.LogParser;
import jeus.loganalyzer.analysis.WorkerThread;
import jeus.loganalyzer.util.LogConstants;

public class Channel {
    private WorkerThread[] threadPool;
    private static int threadCount = 0;
    private static final int MAX_REQUEST = 10;
    private LogParser[] parserQueue;
    private int tail = 0;
    private int head = 0;
    private int count = 0;
    private SimpleDateFormat fileformat = LogConstants.yyyyMMddHHmmss;
    private ThreadGroup threadGroup;

    public Channel(String taskName) {
        this.parserQueue = new LogParser[10];
        this.threadGroup = new ThreadGroup("group-" + taskName);
        this.threadPool[Channel.threadCount] = new WorkerThread(this.threadGroup, "AnalysisWorker[" + taskName + "-" + threadCount + "-" + this.fileformat.format(Calendar.getInstance().getTime()) + "]", this);
        ++threadCount;
    }

    public Channel(String taskName, int threads) {
        this.parserQueue = new LogParser[10];
        this.threadPool = new WorkerThread[threads];
        this.threadGroup = new ThreadGroup("group-" + taskName);
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i] = new WorkerThread(this.threadGroup, "AnalysisWorker[" + taskName + "-" + i + "-" + this.fileformat.format(Calendar.getInstance().getTime()) + "]", this);
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void startWorker() {
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i].start();
        }
    }

    public synchronized void putRequest(LogParser parser) {
        while (this.count >= this.parserQueue.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.parserQueue[this.tail] = parser;
        this.tail = (this.tail + 1) % this.parserQueue.length;
        ++this.count;
        this.notifyAll();
    }

    public synchronized LogParser takeRequest() {
        while (this.count <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        LogParser parser = this.parserQueue[this.head];
        this.head = (this.head + 1) % this.parserQueue.length;
        --this.count;
        this.notifyAll();
        return parser;
    }
}

