/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import jeus.loganalyzer.analysis.LogParser;
import jeus.loganalyzer.analysis.TaskStatus;
import jeus.loganalyzer.common.CheckFieldMethod;
import jeus.loganalyzer.common.PatternInfo;
import jeus.loganalyzer.common.RuleInfo;
import jeus.loganalyzer.util.LogConstants;
import jeus.loganalyzer.util.LogFileEmptyException;
import jeus.loganalyzer.util.MethodUtil;
import jeus.tool.util.FileUtil;
import jeus.util.logging.JeusFormatter;

public class ErrorLogParser
extends LogParser {
    private int totalRows = 0;

    public ErrorLogParser(RuleInfo ruleInfo) throws Exception {
        super(ruleInfo);
        this.init();
    }

    public void execute(String threadID) throws Exception {
        try {
            this.task.setThreadID(threadID);
            this.selectLogFile();
            this.analyze();
            this.createResultList();
            this.task.setStatus(TaskStatus.COMPLETED);
            this.saveStatus();
        }
        catch (LogFileEmptyException empty) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
        }
        catch (Exception e) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
            throw e;
        }
        finally {
            this.close();
        }
    }

    private void createResultList() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.resultDir + this.fs + "resultList", true), 1024);
        writer.write(this.logFilePrefix + "_errorlog" + "=" + this.totalRows + "\n");
        writer.flush();
        writer.close();
    }

    private void selectLogFile() throws IOException {
        String srcFile = null;
        String destFile = null;
        String childDate = null;
        int k = 0;
        int offset = 0;
        long dateLong = 0L;
        String fileName = null;
        this.startDate = this.ruleInfo.getStartDate();
        this.endDate = this.ruleInfo.getEndDate();
        File node = new File(this.srcDir);
        File[] childs = node.listFiles();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            if (!childs[i].isFile() || !(fileName = childs[i].getName()).startsWith(this.logFilePrefix) || !fileName.endsWith(".log")) continue;
            offset = this.logFilePattern.indexOf("%h") > 0 ? fileName.indexOf(".log") - 4 : fileName.indexOf(".log");
            if (this.logFilePattern.indexOf("%d") > 0) {
                childDate = fileName.substring(offset - 8, offset);
                try {
                    dateLong = Long.parseLong(childDate);
                    if (dateLong < this.startDate || dateLong > this.endDate) continue;
                    srcFile = this.srcDir + this.fs + fileName;
                    destFile = this.destDir + this.fs + fileName;
                    this.totalSize += new File(srcFile).length();
                    FileUtil.copy(srcFile, destFile);
                    this.fileList.add(k, destFile);
                    ++k;
                    continue;
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (IOException io) {
                    throw io;
                }
            }
            srcFile = this.srcDir + this.fs + fileName;
            destFile = this.destDir + this.fs + fileName;
            this.totalSize += new File(srcFile).length();
            FileUtil.copy(srcFile, destFile);
            this.fileList.add(k, destFile);
            ++k;
        }
    }

    private void analyze() throws Exception {
        int lists = this.fileList.size();
        if (lists == 0) {
            MethodUtil.rmdir(this.resultDir);
            throw new LogFileEmptyException("not exist log file");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.reportPath + this.fs + this.logFilePrefix + "_errorlog.txt", true), 1024);
        for (int i = 0; i < lists; ++i) {
            this.parsing(this.formatter, writer, (String)this.fileList.elementAt(i));
        }
        writer.flush();
        writer.close();
        FileUtil.rmdir(this.destDir);
    }

    private void parsing(JeusFormatter formatter, BufferedWriter writer, String logFile) throws Exception {
        String line = null;
        HashMap jeusRecord = null;
        boolean flag = false;
        String key = null;
        String value = null;
        String recordValue = null;
        StringBuffer buf = new StringBuffer();
        long logTime = 0L;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
        while ((line = reader.readLine()) != null) {
            this.readDataLen(line);
            if (line.equals("<<__Exception__>>")) {
                writer.write(buf.toString());
                buf = new StringBuffer();
                ++this.totalRows;
                writer.write(line + "\n");
                while (!(line = reader.readLine()).equals("<<__!Exception__>>")) {
                    writer.write(line + "\n");
                }
                writer.write(line + "\n");
                continue;
            }
            try {
                jeusRecord = (HashMap)formatter.getLogRecord(line);
            }
            catch (Exception e) {
                continue;
            }
            logTime = (Long)jeusRecord.get("millis");
            long currentTime = LogConstants.getTimeScaleValue(logTime, 3);
            flag = CheckFieldMethod.checkTime(this.startDate, this.endDate, currentTime);
            if (flag) {
                Enumeration e = this.moduleList.elements();
                while (e.hasMoreElements()) {
                    PatternInfo info = (PatternInfo)e.nextElement();
                    key = info.getField();
                    value = info.getExpression();
                    recordValue = jeusRecord.get(key).toString();
                    if (recordValue == null || (flag = CheckFieldMethod.checksourceModuleName(value, recordValue))) continue;
                }
            }
            if (!flag) continue;
            if (this.tmpSize == 0L) {
                writer.write(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            ++this.totalRows;
            buf.append(line + "\n");
        }
        writer.write(buf.toString());
        reader.close();
    }
}

