/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.analysis;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Vector;
import jeus.loganalyzer.analysis.Task;
import jeus.loganalyzer.analysis.TaskStatus;
import jeus.loganalyzer.common.RuleInfo;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.logging.AccessFormatter;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.UserAccessFormatter;
import jeus.util.properties.JeusPropertyValues;

public abstract class LogParser {
    protected String JEUS_HOME = JeusBootstrapProperties.JEUS_HOME;
    protected String fs = JeusBootstrapPropertyValues.fs;
    protected String srcDir;
    protected String destDir;
    protected String workspaceDir;
    protected String resultDir;
    protected String reportPath;
    protected boolean isAccess;
    protected String logFilePrefix;
    protected String logType = "ERROR_LOGGER";
    protected long totalSize = 0L;
    protected long readSize = 0L;
    protected long tmpSize = 0L;
    protected Vector fileList = new Vector();
    protected String logFilePattern;
    protected long startDate;
    protected long endDate;
    protected long bufSize = 0x100000L;
    protected boolean isfdbSave = true;
    protected int repeatInterval = 1;
    protected ObjectOutputStream statusWriter;
    protected String formatterName;
    protected JeusFormatter formatter;
    protected RuleInfo ruleInfo;
    protected Vector moduleList = new Vector();
    protected String taskName = null;
    protected Task task;

    LogParser(RuleInfo ruleInfo) {
        this.taskName = ruleInfo.getTaskName();
        this.ruleInfo = ruleInfo;
        this.moduleList = ruleInfo.getModuleList();
        this.logType = ruleInfo.getLoggerType();
        this.formatterName = ruleInfo.getFormatterClassName();
    }

    public void init() throws Exception {
        if (this.bufSize == -1L) {
            this.isfdbSave = false;
        } else {
            this.bufSize = this.ruleInfo.getBufferSize();
        }
        this.task = new Task();
        try {
            File report;
            File dest;
            Class<?> c = Class.forName(this.formatterName);
            Object formatterObj = c.newInstance();
            if (formatterObj instanceof UserAccessFormatter) {
                this.formatter = (UserAccessFormatter)((Object)formatterObj);
            } else if (formatterObj instanceof AccessFormatter) {
                this.formatter = AccessFormatter.getAccessFormatter(null);
            } else if (formatterObj instanceof SimpleFormatter) {
                this.formatter = (SimpleFormatter)formatterObj;
            } else {
                Class<?> c1 = Class.forName(this.formatterName);
                this.formatter = (JeusFormatter)c1.newInstance();
            }
            this.logFilePattern = this.ruleInfo.getFilePattern();
            this.setLogFilePattern(this.logFilePattern);
            this.resultDir = JeusPropertyValues.JEUS_LOGANALYZER_HOME + this.fs + "__task__" + this.fs + this.taskName;
            this.workspaceDir = JeusBootstrapProperties.JEUS_HOME + this.fs + "workspace" + this.fs + "__task__" + this.fs + this.taskName;
            this.reportPath = this.resultDir + this.fs + "report";
            this.destDir = this.workspaceDir + this.fs + "logs";
            File logs = new File(this.resultDir);
            if (!logs.isDirectory()) {
                logs.mkdirs();
            }
            if (!(dest = new File(this.workspaceDir)).isDirectory()) {
                dest.mkdirs();
            }
            if (!(report = new File(this.reportPath)).isDirectory()) {
                report.mkdirs();
            }
            this.task.setName(this.taskName);
            this.task.setStartDate(new Date());
            this.task.setStatus(TaskStatus.RUNNING);
            FileOutputStream fos = new FileOutputStream(this.resultDir + this.fs + this.taskName + ".ser");
            this.statusWriter = new ObjectOutputStream(fos);
            this.saveStatus();
        }
        catch (Exception e) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
            throw e;
        }
    }

    public abstract void execute(String var1) throws Exception;

    public void close() throws Exception {
        if (this.fileList != null) {
            this.fileList.clear();
        }
        if (this.statusWriter != null) {
            this.statusWriter.close();
        }
        if (this.moduleList != null) {
            this.moduleList.clear();
        }
        this.totalSize = 0L;
        this.readSize = 0L;
        this.tmpSize = 0L;
    }

    public void saveStatus() throws IOException {
        if (this.statusWriter != null) {
            this.statusWriter.reset();
        }
        if (this.statusWriter != null) {
            this.statusWriter.writeObject(this.task);
        }
        if (this.statusWriter != null) {
            this.statusWriter.flush();
        }
    }

    public String getResultPath() {
        return this.resultDir;
    }

    private void setLogFilePattern(String path) {
        int index = path.indexOf("%d");
        int dirIdx = 0;
        path = File.separatorChar == '/' ? path.replace('\\', File.separatorChar) : path.replace('/', File.separatorChar);
        if (index > 0) {
            dirIdx = path.lastIndexOf(this.fs);
            this.srcDir = path.substring(0, dirIdx);
            this.logFilePrefix = path.substring(dirIdx + 1, index - 1);
        } else {
            dirIdx = path.lastIndexOf(this.fs);
            this.srcDir = path.substring(0, dirIdx);
            this.logFilePrefix = path.substring(dirIdx + 1, path.lastIndexOf("."));
        }
    }

    protected void readDataLen(String line) {
        long len = line.getBytes().length;
        this.tmpSize += len;
        this.readSize += len;
        if (this.bufSize > 0L && this.tmpSize >= this.bufSize) {
            this.tmpSize = 0L;
        }
    }
}

