/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common;

import java.io.File;
import java.io.FileInputStream;
import java.text.Collator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import jeus.loganalyzer.pattern.PatternStorage;
import jeus.util.properties.JeusLogAnalyzerProperties;

public class LogAnalyzerProperty {
    private static LogAnalyzerProperty instance = null;
    private static Properties pattern = null;
    private HashMap patternTable = new HashMap();

    private LogAnalyzerProperty() throws Exception {
        File file = null;
        try {
            String dir = JeusLogAnalyzerProperties.PROPERTIES_PATH;
            pattern = new Properties();
            pattern.setProperty("remoteIP", "jeus.loganalyzer.pattern.RemoteIP");
            pattern.setProperty("localIP", "jeus.loganalyzer.pattern.LocalIP");
            pattern.setProperty("contentLength", "jeus.loganalyzer.pattern.ContentLength");
            pattern.setProperty("protocol", "jeus.loganalyzer.pattern.Protocol");
            pattern.setProperty("remoteUser", "jeus.loganalyzer.pattern.RemoteUser");
            pattern.setProperty("remoteIP", "jeus.loganalyzer.pattern.RemoteIP");
            pattern.setProperty("serverName", "jeus.loganalyzer.pattern.ServerName");
            pattern.setProperty("serverPort", "jeus.loganalyzer.pattern.ServerPort");
            pattern.setProperty("method", "jeus.loganalyzer.pattern.Method");
            pattern.setProperty("status", "jeus.loganalyzer.pattern.Status");
            pattern.setProperty("queryString", "jeus.loganalyzer.pattern.QueryString");
            pattern.setProperty("requestURL", "jeus.loganalyzer.pattern.RequestURL");
            pattern.setProperty("sessionId", "jeus.loganalyzer.pattern.SessionId");
            pattern.setProperty("processingTime", "jeus.loganalyzer.pattern.ProcessingTime");
            pattern.setProperty("millis", "jeus.loganalyzer.pattern.Millis");
            if (dir != null) {
                file = new File(dir);
                pattern.load(new FileInputStream(file));
            }
        }
        catch (Exception ioexception) {
            throw new Exception(file.toString(), ioexception);
        }
    }

    public static LogAnalyzerProperty getInstance() throws Exception {
        if (instance == null) {
            instance = new LogAnalyzerProperty();
        }
        return instance;
    }

    public String getProperty(String keyName) {
        String value = pattern.getProperty(keyName);
        if (value == null || value.equals("")) {
            return null;
        }
        return value.trim();
    }

    public String getKey(String s) {
        Properties properties = null;
        Collator collator = Collator.getInstance();
        if (pattern.containsValue(s)) {
            properties = pattern;
        }
        String s1 = null;
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String s2 = (String)enumeration.nextElement();
                if (collator.compare(properties.getProperty(s2), s) != 0) continue;
                s1 = s2;
                break;
            }
        }
        return s1;
    }

    public PatternStorage getPatternObject(String key) {
        Object pattern = this.patternTable.get(key);
        return (PatternStorage)pattern;
    }

    public HashMap getPatternTable() {
        return this.patternTable;
    }

    public void addPatternObject(String key, PatternStorage obj) {
        this.patternTable.put(key, obj);
    }

    public void clear() {
        this.patternTable.clear();
    }
}

