/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StackTraceMonitor
extends Thread {
    private long checkInterval = 60000L;
    private boolean running = false;
    private String filename = null;
    private RandomAccessFile logfile;
    private long endpoint_fd = 0L;
    private long before_fd = 0L;

    public StackTraceMonitor(long interval, String path) {
        if (interval >= 1000L) {
            this.checkInterval = interval;
        }
        this.filename = path;
        try {
            this.logfile = new RandomAccessFile(new File(this.filename), "rw");
            this.before_fd = this.logfile.length();
            this.logfile.seek(this.before_fd);
            this.logfile.getFD().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = true;
        this.setDaemon(true);
        this.start();
    }

    private void readLogFile() throws IOException {
        this.endpoint_fd = this.logfile.length();
        long dataLen = this.endpoint_fd - this.before_fd;
        byte[] content = new byte[(int)dataLen];
        this.logfile.read(content);
        this.before_fd = this.endpoint_fd;
        this.logfile.seek(this.before_fd);
        this.logfile.getFD().sync();
    }

    void finish() {
        this.running = false;
        this.interrupt();
    }

    public void run() {
        while (this.running) {
            try {
                StackTraceMonitor.sleep(this.checkInterval);
                this.readLogFile();
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

