/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.pattern;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import jeus.loganalyzer.common.StorageEntry;

public abstract class PatternStorage
implements Serializable {
    protected String fileDBPath;
    protected String fileDBName;
    protected String fileDir;
    protected String fileName;
    protected HashMap fpTable;
    protected HashMap logDataTable;
    protected transient RandomAccessFile DBfile;
    protected StorageEntry entry;
    File file1;
    protected int totalLen;
    protected int KEY_SIZE;
    protected int BODY_SIZE;
    protected long totalHits;
    protected long totalTime;

    public PatternStorage(String _fileDBPath, String _fileDBName) {
        this.fileDBPath = _fileDBPath;
        this.fileDBName = _fileDBName;
        this.initializeHeaderInfo();
    }

    public abstract void initializeHeaderInfo();

    protected void makeDBFile() throws IOException {
        this.fileName = this.fileDBName + ".fdb";
        this.fileDir = this.fileDBPath + File.separator + this.fileName;
        this.file1 = new File(this.fileDir);
        if (this.file1.getParent() != null) {
            new File(this.file1.getParent()).mkdirs();
        }
        this.DBfile = new RandomAccessFile(this.file1, "rw");
        this.DBfile.seek(this.DBfile.length());
    }

    public abstract boolean isDigist();

    public abstract void store(String var1, long var2) throws IOException;

    public abstract void update(String var1, long var2) throws IOException;

    public abstract void flush() throws IOException;

    public HashMap getFPTable() {
        return this.fpTable;
    }

    public HashMap getDataTable() {
        return this.logDataTable;
    }

    public RandomAccessFile getDBfile() {
        return this.DBfile;
    }

    public String getFileDir() {
        return this.fileDBPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean checkKey(String idx) {
        return this.fpTable.containsKey(idx);
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public String getFileDBName() {
        return this.fileDBName;
    }

    public void setFileDBName(String fileDBName) {
        this.fileDBName = fileDBName;
    }

    public String getFileDBPath() {
        return this.fileDBPath;
    }

    public void setFileDBPath(String fileDBPath) {
        this.fileDBPath = fileDBPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            if (this.fpTable != null) {
                this.fpTable.clear();
            }
            if (this.logDataTable != null) {
                this.logDataTable.clear();
            }
            this.fileDBPath = null;
            this.fileDBName = null;
            this.fpTable = null;
            this.logDataTable = null;
            this.entry = null;
            try {
                if (this.DBfile != null) {
                    this.DBfile.close();
                }
            }
            catch (Throwable ex) {
                throw new Exception("fail to clear()", ex);
            }
            this.file1 = null;
        }
    }
}

