/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.pattern;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jeus.loganalyzer.common.StorageEntry;
import jeus.loganalyzer.pattern.AccessDefaultStorage;

public class ProcessingTime
extends AccessDefaultStorage {
    public boolean isDigist() {
        return true;
    }

    public ProcessingTime(String fileDBPath, String fileDBName) {
        super(fileDBPath, fileDBName);
    }

    public void store(String idx, long value) throws IOException {
        byte[] key = idx.getBytes();
        this.totalLen = this.KEY_SIZE + key.length + this.BODY_SIZE;
        byte[] content = new byte[this.totalLen];
        content = this.writeData(this.totalLen, key, value);
        this.logDataTable.put(idx, content);
        this.entry = new StorageEntry(-1L, content.length);
        this.fpTable.put(idx, this.entry);
    }

    public void update(String idx, long value) throws IOException {
        this.entry = (StorageEntry)this.fpTable.get(idx);
        byte[] content = new byte[(int)this.entry.length];
        if (this.logDataTable.containsKey(idx)) {
            content = (byte[])this.logDataTable.get(idx);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, value));
        } else {
            long originalPointer = this.DBfile.getFilePointer();
            this.DBfile.seek(this.entry.startAdd);
            this.DBfile.read(content);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, value));
            this.DBfile.seek(originalPointer);
            this.DBfile.getFD().sync();
        }
    }

    protected byte[] readData(long entryLen, byte[] content, long value) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        int keyLen = dis.readInt();
        byte[] key = new byte[keyLen];
        dis.readFully(key);
        long readValue = dis.readLong();
        content = this.writeData(entryLen, key, readValue += value);
        return content;
    }

    protected byte[] writeData(long entryLen, byte[] key, long value) throws IOException {
        ++this.totalHits;
        this.totalTime += value;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)entryLen);
        DataOutputStream dout = new DataOutputStream(bos);
        dout.writeInt(key.length);
        dout.write(key, 0, key.length);
        dout.writeLong(value);
        return bos.toByteArray();
    }
}

