/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LogConstants {
    public static int ANA_MODE_DATE = 0;
    public static int ANA_MODE_CLIENTIP = 1;
    public static int ANA_MODE_URI = 2;
    public static int ANA_MODE_TIME = 3;
    public static String[] ITEMS$M = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    public static String[] ITEM$HH24 = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static String[] ITEM$W = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturaday"};
    public static String[] timeTitle = new String[]{"00:00:00-00:59:59", "01:00:00-01:59:59", "02:00:00-02:59:59", "03:00:00-03:59:59", "04:00:00-04:59:59", "05:00:00-05:59:59", "06:00:00-06:59:59", "07:00:00-07:59:59", "08:00:00-08:59:59", "09:00:00-09:59:59", "10:00:00-10:59:59", "11:00:00-11:59:59", "12:00:00-12:59:59", "13:00:00-13:59:59", "14:00:00-14:59:59", "15:00:00-15:59:59", "16:00:00-16:59:59", "17:00:00-17:59:59", "18:00:00-18:59:59", "19:00:00-19:59:59", "20:00:00-20:59:59", "21:00:00-21:59:59", "22:00:00-22:59:59", "23:00:00-23:59:59"};
    public static final String[] day_columnNames = new String[]{"Date", "Hits", "Hit Rate(%)", "Errors", "200OK Code Rate(%)", "Processiong Time Avg(ms)"};
    public static final String[] time_columnNames = new String[]{"Time", "Hits", "Hit Rate(%)", "Errors", "200OK Code Rate(%)", "Processiong Time Avg(ms)"};
    public static final String[] ip_columnNames = new String[]{"Client IP", "Hits", "Hit Rate(%)", "Errors", "200OK Code Rate(%)", "Processiong Time Avg(ms)"};
    public static final String[] uri_columnNames = new String[]{"Resource URI", "Hits", "Hit Rate(%)", "Errors", "200OK Code Rate(%)", "Processiong Time Avg(ms)"};
    public static final String[] pattern_columnNames = new String[]{"pattern value", "hits or average time", "percentage(%)"};
    public static final String[] contents = new String[]{"contents"};
    public static final int TIME_TYPE_YEARLY = 0;
    public static final int TIME_TYPE_MONTHLY = 1;
    public static final int TIME_TYPE_WEEKLY = 2;
    public static final int TIME_TYPE_DAYLY = 3;
    public static final int TIME_TYPE_HOURLY = 4;
    public static final String TIME_SCALE_TYPE$HOUR = "TIME";
    public static final String TIME_SCALE_TYPE$DAY = "DAY";
    public static final String TIME_SCALE_TYPE$WEEK = "WEEK";
    public static final String TIME_SCALE_TYPE$MONTH = "MONTH";
    public static final String TIME_SCALE_TYPE$YEAR = "YEAR";
    public static final String KEY_TYPE_IP = "CLIENTIP_STATISTICS";
    public static final String KEY_TYPE_URI = "REQUESTURI_STATISTICS";
    public static final String KEY_ITEM_POSTFIX = "_STATISTICS";
    public static final String KEY_WEEK_PROCTIME = "weekly_processTime";
    public static final String KEY_DATE_PROCTIME = "dayly_processTime";
    public static final String KEY_HOUR_PROCTIME = "hourly_processTime";
    public static final String KEY_IP_PROCTIME = "ip_processTime";
    public static final String KEY_URI_PROCTIME = "uri_processTime";
    public static final String EXCEPTION_PREFIX = "<<__Exception__>>";
    public static final String EXCEPTION_POSTFIX = "<<__!Exception__>>";
    public static final SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat yyyyMMddHH = new SimpleDateFormat("yyyyMMddHH");
    private static final SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat yyyyMMW = new SimpleDateFormat("yyyyMMW");
    private static final SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyyMM");
    private static final SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");

    public static long getTimeScaleValue(long currentTime, int type) {
        long dateValue = 0L;
        switch (type) {
            case 0: {
                dateValue = Long.parseLong(yyyy.format(new Date(currentTime)));
                break;
            }
            case 1: {
                dateValue = Long.parseLong(yyyyMM.format(new Date(currentTime)));
                break;
            }
            case 2: {
                dateValue = Long.parseLong(yyyyMMW.format(new Date(currentTime)));
                break;
            }
            case 4: {
                dateValue = Long.parseLong(yyyyMMddHH.format(new Date(currentTime)));
                break;
            }
            default: {
                dateValue = Long.parseLong(yyyyMMdd.format(new Date(currentTime)));
            }
        }
        return dateValue;
    }

    public static String getTimeScaleKey(long currentTime, int type) {
        String dateKey = null;
        switch (type) {
            case 0: {
                dateKey = yyyy.format(new Date(currentTime));
                break;
            }
            case 1: {
                dateKey = yyyyMM.format(new Date(currentTime));
                break;
            }
            case 2: {
                dateKey = yyyyMMW.format(new Date(currentTime));
                break;
            }
            case 4: {
                dateKey = yyyyMMddHH.format(new Date(currentTime));
                break;
            }
            default: {
                dateKey = yyyyMMdd.format(new Date(currentTime));
            }
        }
        return dateKey;
    }

    public static String getWeekKey(Calendar calendar) {
        String weekDay = ITEM$W[0];
        int weekly = calendar.get(7);
        switch (weekly) {
            case 1: {
                weekDay = ITEM$W[0];
                break;
            }
            case 2: {
                weekDay = ITEM$W[1];
                break;
            }
            case 3: {
                weekDay = ITEM$W[2];
                break;
            }
            case 4: {
                weekDay = ITEM$W[3];
                break;
            }
            case 5: {
                weekDay = ITEM$W[4];
                break;
            }
            case 6: {
                weekDay = ITEM$W[5];
                break;
            }
            case 7: {
                weekDay = ITEM$W[6];
            }
        }
        return weekDay;
    }

    public static String getHourKey(String tokenHour) {
        String timeKey = null;
        int hour = (int)Long.parseLong(tokenHour);
        timeKey = hour < 0 || hour >= timeTitle.length ? timeTitle[0] : timeTitle[hour];
        return timeKey;
    }
}

