/*
 * Decompiled with CFR 0.152.
 */
package jeus.management;

import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.JeusAuthenticatorImpl;
import jeus.management.JeusMBeanServerAccessController;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.remote.JeusMPUtility;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.management.snmp.agent.SnmpAgentForRMIImpl;
import jeus.management.snmp.agent.SnmpAgentImpl;
import jeus.management.snmp.util.SnmpConstant;
import jeus.security.util.LoginUtil;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.service.SnmpAgentService;
import jeus.util.JeusPort;
import jeus.util.JeusRMIClientSocketFactory;
import jeus.util.JeusRuntimeException;
import jeus.util.Runner;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.message.JeusMessage_SNMP;
import jeus.util.properties.JeusJMXPropertyValues;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetProperties;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.jeusDD.JmxConnectorType;
import jeus.xml.binding.jeusDD.JmxmpConnectorType;
import jeus.xml.binding.jeusDD.RmiConnectorType;

public class JMXManager {
    private ObjectName htmlAdaptorName;
    private static boolean isWorking;
    private static JMXManagerDescriptor desc;
    private static JMXManager singleTone;
    private CommunicatorServer htmlAdaptor;
    private SnmpAgent snmpAgent;
    private J2EEManagedObject snmpAgentService;
    private static final JeusLogger logger;
    private HashMap jmxConnectorMap = new HashMap();

    public static String getName() {
        return JeusJMXPropertyValues.jmxMgrName;
    }

    public static void init(JMXManagerDescriptor desc, String ManagerName, boolean isJeusManager) throws JeusServerException {
        if (desc == null) {
            desc = new JMXManagerDescriptor();
        }
        JMXManager.desc = desc;
        JeusJMXPropertyValues.jmxMgrName = ManagerName;
        singleTone = new JMXManager();
        singleTone.innerInit();
    }

    private void innerInit() throws JeusServerException {
        try {
            String usePlatformMBeanServer = System.getProperty("jeus.jmx.usePlatformMBeanServer");
            JeusJMXPropertyValues.mBeanServer = Boolean.valueOf(usePlatformMBeanServer) != false ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer();
            if (logger.isLoggable(JeusMessage_JMX.JMX_46_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_46_LEVEL, JeusMessage_JMX.JMX_46);
            }
            this.registerMLets();
            isWorking = true;
            MEJBUtility.setMBeanServer((MBeanServer)JeusJMXPropertyValues.mBeanServer);
            MEJBUtility.setServerName((String)JeusJMXPropertyValues.jmxMgrName);
        }
        catch (Throwable t) {
            throw new JeusServerException(JeusMessage_JMX.JMX_47, t);
        }
    }

    public static void stop() throws JeusServerException {
        try {
            singleTone.stopAllExported();
            MBeanServerFactory.releaseMBeanServer(JeusJMXPropertyValues.mBeanServer);
            MEJBUtility.clear();
            JeusJMXPropertyValues.mBeanServer = null;
            desc = null;
            isWorking = false;
        }
        catch (Throwable t) {
            throw new JeusServerException(JeusMessage_JMX.JMX_48, t);
        }
    }

    private void stopAllExported() {
        for (ArrayList connectorList : this.jmxConnectorMap.values()) {
            for (int j = 0; j < connectorList.size(); ++j) {
                Object[] connectorInfo = (Object[])connectorList.get(j);
                this.unexportJMXConnector(connectorInfo);
            }
        }
        this.jmxConnectorMap.clear();
        this.stopAdaptorAndConnector();
    }

    private void unexportJMXConnector(Object[] connectorInfo) {
        JMXConnectorServer cs = (JMXConnectorServer)connectorInfo[0];
        ObjectName rmiConnectorName = (ObjectName)connectorInfo[1];
        String refExportName = (String)connectorInfo[2];
        try {
            if (cs != null) {
                cs.stop();
                this.unbindRMIConnector(refExportName);
                cs.getMBeanServer().unregisterMBean(rmiConnectorName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isWorking() {
        return isWorking;
    }

    private void registerMLets() {
        Vector urls = desc.getMletFileURLs();
        Enumeration e = urls.elements();
        while (e.hasMoreElements()) {
            Set<Object> results;
            String url = (String)e.nextElement();
            try {
                MLet mLet = new MLet();
                mLet.preRegister(JeusJMXPropertyValues.mBeanServer, null);
                results = mLet.getMBeansFromURL(url);
                mLet.postRegister(Boolean.TRUE);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_JMX.JMX_49_LEVEL)) continue;
                logger.log(JeusMessage_JMX.JMX_49_LEVEL, JeusMessage_JMX.JMX_49, (Object)url, t);
                continue;
            }
            for (Object result : results) {
                if (!(result instanceof Throwable) || !logger.isLoggable(JeusMessage_JMX.JMX_49_LEVEL)) continue;
                logger.log(JeusMessage_JMX.JMX_49_LEVEL, JeusMessage_JMX.JMX_49, (Object)url, (Throwable)result);
            }
        }
    }

    private void startAdaptorAndConnector(String managerName, boolean isContainer) {
        block3: {
            int port = desc.getHTMLAdaptorPort();
            if (port != -1) {
                try {
                    this.htmlAdaptor = new HtmlAdaptorServer(port);
                    Hashtable<String, String> t = new Hashtable<String, String>();
                    t.put("name", managerName);
                    t.put("j2eeType", "JeusService");
                    t.put("jeusType", "HttpAdaptor");
                    t.put("JMXManager", managerName);
                    String objectName = JMXUtility.makeObjectNameFromMap(t, null);
                    this.htmlAdaptorName = new ObjectName(objectName);
                    JeusJMXPropertyValues.mBeanServer.registerMBean(this.htmlAdaptor, this.htmlAdaptorName);
                    this.htmlAdaptor.start();
                }
                catch (Throwable t) {
                    this.htmlAdaptor = null;
                    if (!logger.isLoggable(JeusMessage_JMX.JMX_50_LEVEL)) break block3;
                    logger.log(JeusMessage_JMX.JMX_50_LEVEL, JeusMessage_JMX.JMX_50, t);
                }
            }
        }
    }

    public static ObjectName exportSNMPAdaptor(JMXManagerDescriptor desc, boolean isContainer, String managerName) {
        return singleTone.startSNMPAdaptor(desc, isContainer, managerName);
    }

    private ObjectName startSNMPAdaptor(JMXManagerDescriptor desc, boolean isContainer, String managerName) {
        int port;
        if (desc == null) {
            if (JMXManager.desc == null) {
                return null;
            }
            desc = JMXManager.desc;
        }
        if ((port = desc.getSNMPAdaptorPort()) != -1) {
            if (!Runner.checkLicenseEdition(Runner.LIC_EDITION_STANDARD)) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_50_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_50_LEVEL, JeusMessage_SNMP.SNMP_50);
                }
                return null;
            }
            try {
                if (!SnmpConstant.IS_DYNAMIC_SNMP_OID) {
                    this.snmpAgent = new SnmpAgentForRMIImpl(port, desc);
                    InitialContext ctx = new InitialContext();
                    ctx.rebind("SnmpAgent", (Object)this.snmpAgent);
                } else {
                    this.snmpAgent = new SnmpAgentImpl(port, desc, managerName);
                }
                this.snmpAgentService = isContainer ? SnmpAgentService.createMBean(managerName, EngineContainer.serverMBean.getObjectName(), this.snmpAgent) : SnmpAgentService.createMBean(managerName, JeusServer.jeusManager.getObjectName(), this.snmpAgent);
                this.snmpAgent.setMbeanName(this.snmpAgentService.getObjectName());
                this.snmpAgent.start();
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_1_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_1_LEVEL, JeusMessage_SNMP.SNMP_1, t);
                }
                return null;
            }
            return this.snmpAgentService.getObjectName();
        }
        return null;
    }

    public static void exportJMXManager(String managerName, boolean isContainer) throws JMXManagerException {
        singleTone.exportMBeanServer(managerName, isContainer);
    }

    private void exportMBeanServer(String managerName, boolean isContainer) throws JMXManagerException {
        try {
            JMXConnectorServer cs;
            Hashtable<String, String> envOriginal = new Hashtable<String, String>();
            envOriginal.put("jeus.jndi.jns.forcedbindings", "true");
            String remoteName = "mgmt/rmbs/" + managerName;
            Hashtable<String, String> t = new Hashtable<String, String>();
            t.put("name", managerName);
            t.put("j2eeType", "JeusService");
            t.put("JMXManager", managerName);
            JmxConnectorType connectorType = desc.getJMXConnector();
            boolean isJEUSMPConnector = false;
            int connectorPort = 0;
            RmiConnectorType rmiConnectorType = null;
            if (connectorType == null) {
                isJEUSMPConnector = true;
            } else {
                JmxmpConnectorType jeusmpConnector = connectorType.getJmxmpConnector();
                rmiConnectorType = connectorType.getRmiConnector();
                if (jeusmpConnector != null) {
                    isJEUSMPConnector = true;
                    connectorPort = jeusmpConnector.getJmxmpConnectorPort();
                } else if (rmiConnectorType != null && rmiConnectorType.getRefExportName() != null) {
                    throw new JMXManagerException("If the JMXMPConnector is not used, the export name of RMIConnector should be the default value, cannot be set");
                }
            }
            ArrayList<Object[]> connectorList = new ArrayList<Object[]>();
            if (isJEUSMPConnector) {
                Hashtable env = new Hashtable(envOriginal);
                cs = JeusMPUtility.exportJeusMPConnector((int)connectorPort, (int)(isContainer ? JeusManagerPropertyValues.getBasePort() : JeusPort.JeusBase), (String)("/JEUSMP_" + (isContainer ? JeusManagerPropertyValues.containerName : VirtualDNS.LOCAL_VIRTUALNAME)), env);
                JMXServiceURL url = cs.getAddress();
                Reference ref = new Reference(JMXConnector.class.getName(), "jeus.management.remote.jeusmp.JeusmpConnectorFactory", null);
                ref.add(0, new StringRefAddr("protocol", url.getProtocol()));
                ref.add(1, new StringRefAddr("host", JeusNetPropertyValues.LOCAL_FULL_HOSTNAME));
                ref.add(2, new StringRefAddr("port", String.valueOf(url.getPort())));
                ref.add(3, new StringRefAddr("urlPath", url.getURLPath()));
                ref.add(4, new StringRefAddr("checktmout", Integer.toString(JeusNetProperties.CHECK_TIMEOUT)));
                ref.add(5, new StringRefAddr("ipaddr", JeusNetPropertyValues.LOCAL_HOSTADDRESS));
                InitialContext context = new InitialContext(env);
                context.rebind(remoteName, (Object)ref);
                Hashtable<String, String> temp = new Hashtable<String, String>(t);
                temp.put("jeusType", "JEUSMPConnector");
                String objectName = JMXUtility.makeObjectNameFromMap(temp, null);
                ObjectName jmxConnectorName = new ObjectName(objectName);
                JeusJMXPropertyValues.mBeanServer.registerMBean(cs, jmxConnectorName);
                connectorList.add(new Object[]{cs, jmxConnectorName, remoteName});
            }
            if (rmiConnectorType != null) {
                int port = rmiConnectorType.getRmiConnectorPort();
                String exportName = "/jndi/" + rmiConnectorType.getExportName();
                JMXServiceURL url = new JMXServiceURL("rmi", JeusNetPropertyValues.LOCAL_HOSTADDRESS, port, exportName);
                Hashtable<String, Object> env = new Hashtable<String, Object>(envOriginal);
                env.put("jmx.remote.authenticator", new JeusAuthenticatorImpl());
                env.put("jmx.remote.rmi.client.socket.factory", new JeusRMIClientSocketFactory(JeusNetProperties.CHECK_TIMEOUT));
                cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, JeusJMXPropertyValues.mBeanServer);
                cs.setMBeanServerForwarder((MBeanServerForwarder)new JeusMBeanServerAccessController());
                cs.start();
                Reference ref = new Reference(JMXConnector.class.getName(), "jeus.management.remote.rmi.RMIConnectorFactory", null);
                ref.add(0, new StringRefAddr("serviceUrl", url.toString()));
                InitialContext context = new InitialContext(env);
                String refExportName = rmiConnectorType.getRefExportName();
                if (isJEUSMPConnector) {
                    if (refExportName == null || refExportName.equals(remoteName)) {
                        throw new JeusRuntimeException("The reference export name for rmi connector should be set to use both rmi connector and jmxmp connector, and it cannot be the same value with that of the jmxmp connector");
                    }
                } else if (refExportName == null) {
                    refExportName = remoteName;
                }
                if (refExportName != null) {
                    context.rebind(refExportName, (Object)ref);
                }
                Hashtable<String, String> temp = new Hashtable<String, String>(t);
                temp.put("jeusType", "RMIConnector");
                String objectName = JMXUtility.makeObjectNameFromMap(temp, null);
                ObjectName jmxConnectorName = new ObjectName(objectName);
                JeusJMXPropertyValues.mBeanServer.registerMBean(cs, jmxConnectorName);
                connectorList.add(new Object[]{cs, jmxConnectorName, refExportName});
                if (logger.isLoggable(JeusMessage_JMX.JMX_132_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_132_LEVEL, JeusMessage_JMX.JMX_132, (Object)url.toString());
                }
            }
            this.jmxConnectorMap.put(managerName, connectorList);
            this.startAdaptorAndConnector(managerName, isContainer);
            if (logger.isLoggable(JeusMessage_JMX.JMX_51_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_51_LEVEL, JeusMessage_JMX.JMX_51, (Object)remoteName);
            }
        }
        catch (Exception re) {
            throw new JMXManagerException(JeusMessage_JMX.JMX_52, managerName, (Throwable)re);
        }
    }

    private void unbindRMIConnector(String refExportName) throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            ctx.unbind(refExportName);
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAdaptorAndConnector() {
        try {
            if (this.htmlAdaptor != null) {
                this.htmlAdaptor.stop();
                if (JeusJMXPropertyValues.mBeanServer != null) {
                    JeusJMXPropertyValues.mBeanServer.unregisterMBean(this.htmlAdaptorName);
                }
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_53_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_53_LEVEL, JeusMessage_JMX.JMX_53, t);
            }
        }
        finally {
            this.htmlAdaptor = null;
        }
        this.stopSNMPAdaptor();
    }

    public static void unexportSNMPAdaptor() {
        singleTone.stopSNMPAdaptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSNMPAdaptor() {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            if (this.snmpAgentService != null) {
                this.snmpAgentService.destroyMBean();
            }
            if (this.snmpAgent != null) {
                this.snmpAgent.stop();
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_2_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_2_LEVEL, JeusMessage_SNMP.SNMP_2, t);
            }
        }
        finally {
            this.snmpAgentService = null;
            this.snmpAgent = null;
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public static MBeanServer getMbeanServer() throws JMXManagerException {
        if (singleTone != null) {
            return JeusJMXPropertyValues.mBeanServer;
        }
        throw new JMXManagerException(JeusMessage_JMX.JMX_13);
    }

    public static void unexportJMXManager(String managerName) throws JMXManagerException {
        singleTone.unexportMBeanServer(managerName);
    }

    private void unexportMBeanServer(String managerName) throws JMXManagerException {
        try {
            ArrayList list = (ArrayList)this.jmxConnectorMap.remove(managerName);
            for (int i = 0; i < list.size(); ++i) {
                Object[] connectorInfo = (Object[])list.get(i);
                this.unexportJMXConnector(connectorInfo);
            }
            singleTone.stopAdaptorAndConnector();
        }
        catch (Throwable t) {
            throw new JMXManagerException(JeusMessage_JMX.JMX_54, t);
        }
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    }
}

