/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.security.base.SecurityException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;

public class ListenerRegistry
implements ListenerRegistration {
    private transient MEJBUtility utility;

    public ListenerRegistry(MEJBUtility utility) {
        this.utility = utility;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws RemoteException {
        try {
            this.utility.addNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred", e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws RemoteException {
        try {
            this.utility.removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred", e);
        }
    }

    private void writeObject(ObjectOutputStream ostream) throws IOException {
        ostream.defaultWriteObject();
        byte[] credentials = (byte[])this.utility.getCredential();
        ostream.writeInt(credentials.length);
        ostream.write(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
        int subjectLength = istream.readInt();
        byte[] subjectByte = new byte[subjectLength];
        try {
            Subject credentials = Subject.deserialize(subjectByte);
            LoginService.login(credentials);
            try {
                this.utility = MEJBUtility.getMEJBUtility();
            }
            finally {
                LoginService.logout();
            }
        }
        catch (SecurityException e) {
            throw new JeusRuntimeException("Authentication failed");
        }
        catch (Exception e) {
            throw new JeusRuntimeException("Exception occurred", (Throwable)e);
        }
    }
}

