/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jeus.descriptor.tmonitor.TroubleMonitorDescriptor;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MBSCAlreadyClosedException;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.enterprise.support.NotificationBroadcasterSupport;
import jeus.management.enterprise.support.NullNotificationBroadcasterSupport;
import jeus.management.j2ee.EventProvider;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2eeNotificationImpl;
import jeus.management.j2ee.StateManageable;
import jeus.management.j2ee.StatisticsProvider;
import jeus.management.j2ee.Targetable;
import jeus.management.j2ee.monitor.DataProvider;
import jeus.management.j2ee.monitor.MonitorHandler;
import jeus.management.j2ee.monitor.RatioMonitorHandler;
import jeus.management.j2ee.tmonitor.Trouble;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusJMXPropertyValues;

public abstract class J2EEManagedObject
implements J2EEManagedObjectMBean,
MBeanRegistration {
    protected long bootTime;
    protected volatile int state = 3;
    protected static final String[] STATE_STRING = new String[]{"START", "RUNNING", "STOPPING", "STOPPED", "FAILED"};
    private static final Object[] dummyParam = new Object[0];
    private static final String[] dummySignature = new String[0];
    private transient NotificationBroadcasterSupport notificationDelegate = NullNotificationBroadcasterSupport.nullDelegate;
    protected String myName;
    protected ObjectName myObjectName;
    protected ObjectName parentObjectName;
    private long sequenceNumber;
    private final Object sequenceSync = new Object();
    protected String myNameString;
    protected String myTypeString;
    protected String myJeusTypeString;
    private transient Vector stateManageableList = new Vector();
    protected transient MBeanServer mbs;
    protected static final String[] LISTENER_PARAM_STRING = new String[]{"javax.management.NotificationListener", "javax.management.NotificationFilter", "java.lang.Object"};
    private transient Hashtable children = new Hashtable();
    public static final J2EEManagedObject[] dummyArray = new J2EEManagedObject[0];
    public static final J2EEManagedObjectMBean[] dummyMBeanArray = new J2EEManagedObjectMBean[0];
    private static boolean isMEJBUtilityEnabled;
    private static MEJBUtility utility;
    protected static final JeusLogger logger;
    protected transient String permissionName;
    protected transient Permission startPermission;
    private transient ResourcePermission stopPermission;
    private transient ResourcePermission startRecursivePermission;
    private transient Permission getstatePermission;
    private transient ResourcePermission getstartTimePermission;
    protected transient Permission readPropertiesPermission;
    private transient Permission addListenerPermission;
    private transient Permission removeListenerPermission;
    protected transient Permission getstatsPermission;
    private transient MonitorHandler[] monitorList = MonitorHandler.EMPTY_HANDLERS;

    public J2EEManagedObject() {
        this.bootTime = System.currentTimeMillis();
        if (this.iseventProvider()) {
            this.notificationDelegate = new NotificationBroadcasterSupport();
        }
    }

    public J2EEManagedObject(ObjectName parent) {
        this();
        this.parentObjectName = parent;
    }

    public J2EEManagedObject(NotificationBroadcasterSupport notificationSupport) {
        this();
        this.notificationDelegate = notificationSupport;
    }

    public abstract void refreshMonitoring();

    public String getobjectName() {
        return this.myName;
    }

    public ObjectName getObjectName() {
        return this.myObjectName;
    }

    public ObjectName getParentObjectName() {
        return this.parentObjectName;
    }

    public boolean isstateManageable() {
        return this instanceof StateManageable;
    }

    public boolean isstatisticsProvider() {
        return this instanceof StatisticsProvider;
    }

    public boolean iseventProvider() {
        return this instanceof EventProvider;
    }

    private ObjectName buildName(String name, String type, ObjectName parent, String[] parentMap, String jeusType) throws MalformedObjectNameException {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("j2eeType", type);
        prop.put("name", name);
        if (jeusType != null) {
            prop.put("jeusType", jeusType);
        }
        if (this instanceof Targetable) {
            prop.put("isTargetable", "true");
        }
        if (parent != null) {
            Hashtable<String, String> parentProp = parent.getKeyPropertyList();
            String parentName = parentProp.get("name");
            String parentType = parentProp.get("j2eeType");
            if (parentType.equals("JeusService")) {
                parentType = parentProp.get("jeusType");
            }
            prop.put(parentType, parentName);
            if (parentMap != null) {
                if (parentMap.length > 0 && parentMap[0].equals("*")) {
                    Set<Map.Entry<String, String>> propertySet = parentProp.entrySet();
                    for (Map.Entry<String, String> entry : propertySet) {
                        String key = entry.getKey();
                        if (key.equals("name") || key.equals("j2eeType") || key.equals("jeusType")) continue;
                        prop.put(key, entry.getValue());
                    }
                } else {
                    for (int i = 0; i < parentMap.length; ++i) {
                        String parentKey = parentMap[i];
                        if (prop.containsKey(parentKey)) continue;
                        String value = parentProp.get(parentKey);
                        if (value == null) {
                            value = "null";
                        }
                        prop.put(parentKey, value);
                    }
                }
            }
        }
        prop.put("JMXManager", JeusJMXPropertyValues.jmxMgrName);
        this.setAdditionalNameProperties(prop);
        String objectName = JMXUtility.makeObjectNameFromMap(prop, parentMap);
        return new ObjectName(objectName);
    }

    protected abstract void setAdditionalNameProperties(Map var1);

    public J2EEManagedObject createMBean(String mBeanName, String type, ObjectName parent, String[] parentKeyMap, String jeusType) throws InstanceAlreadyExistsException, JeusRuntimeException {
        this.parentObjectName = parent;
        try {
            MBeanServer mbs = JeusJMXPropertyValues.mBeanServer;
            ObjectName objectName = this.buildObjectName(mBeanName, type, parent, parentKeyMap, jeusType);
            if (logger.isLoggable(JeusMessage_JMX.JMX_11_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_11_LEVEL, JeusMessage_JMX.JMX_11, (Object)this.getCannonicalName(objectName));
            }
            mbs.registerMBean(this, objectName);
            this.refreshMonitoring();
            return this;
        }
        catch (InstanceAlreadyExistsException already) {
            throw already;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_14, e);
        }
    }

    public ObjectName buildObjectName(String mBeanName, String type, ObjectName parent, String[] parentKeyMap, String jeusType) throws MalformedObjectNameException {
        return this.buildName(mBeanName, type, parent, parentKeyMap, jeusType);
    }

    public J2EEManagedObject reCreateMBean(String mBeanName, String type, ObjectName parent, String[] parentKeyMap, String jeusType) throws InstanceAlreadyExistsException {
        this.parentObjectName = parent;
        ObjectName objectName = null;
        MBeanServer mbs = null;
        try {
            objectName = this.buildObjectName(mBeanName, type, parent, parentKeyMap, jeusType);
            mbs = JeusJMXPropertyValues.mBeanServer;
            if (logger.isLoggable(JeusMessage_JMX.JMX_11_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_11_LEVEL, JeusMessage_JMX.JMX_11, (Object)objectName);
            }
            mbs.registerMBean(this, objectName);
            return this;
        }
        catch (InstanceAlreadyExistsException already) {
            try {
                mbs.unregisterMBean(objectName);
                mbs.registerMBean(this, objectName);
                return this;
            }
            catch (Throwable e) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_14, e);
            }
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_14, e);
        }
    }

    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbs = server;
        if (name == null) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_15);
        }
        this.myName = name.getCanonicalName();
        this.myObjectName = name;
        this.myNameString = name.getKeyProperty("name");
        this.myTypeString = name.getKeyProperty("j2eeType");
        this.myJeusTypeString = name.getKeyProperty("jeusType");
        this.preCreation();
        return this.myObjectName;
    }

    protected abstract void preCreation() throws Exception;

    public final void postRegister(Boolean pRegistrationDone) {
        try {
            boolean done = pRegistrationDone;
            if (done) {
                this.addChildToParent(this.myObjectName);
            }
            this.postCreation(done);
            this.permissionName = this.initPermissionName();
            this.makePermissions();
        }
        catch (Exception ex) {
            throw new JeusRuntimeException((Throwable)ex);
        }
    }

    protected abstract String initPermissionName() throws JMXManagerException;

    protected void makePermissions() {
        this.readPropertiesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"read_properties");
        if (this.isstateManageable()) {
            this.startPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"start");
            this.stopPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"stop");
            this.startRecursivePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"startRecursive");
            this.getstatePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getstate");
            this.getstartTimePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getstartTime");
        }
        if (this.iseventProvider()) {
            this.addListenerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"addNotificationListener");
            this.removeListenerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"remnNotificationListener");
        }
        if (this.isstatisticsProvider()) {
            this.getstatsPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getstats");
        }
    }

    private void addChildToParent(ObjectName child) {
        if (this.parentObjectName != null) {
            block12: {
                try {
                    LoginService.loginCodeSubject();
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_JMX._75_LEVEL)) break block12;
                    logger.log(JeusMessage_JMX._75_LEVEL, JeusMessage_JMX._75, e);
                }
            }
            try {
                J2EEManagedObject.getMEJBUtility().invoke(this.parentObjectName, "addChild", new Object[]{child}, new String[]{ObjectName.class.getName()});
            }
            catch (Exception e) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_16, (Object[])new String[]{this.parentObjectName.toString(), child.toString()}, (Throwable)e);
            }
            finally {
                block14: {
                    try {
                        LoginService.logout();
                    }
                    catch (Throwable e) {
                        if (!logger.isLoggable(JeusMessage_JMX._75_LEVEL)) break block14;
                        logger.log(JeusMessage_JMX._75_LEVEL, JeusMessage_JMX._75, e);
                    }
                }
            }
        }
    }

    protected static MBeanServerConnection getMEJBUtility() throws JMXManagerException {
        if (isMEJBUtilityEnabled) {
            if (utility == null) {
                utility = MEJBUtility.getMEJBUtility();
            }
            return utility;
        }
        return JeusJMXPropertyValues.mBeanServer;
    }

    public final void preDeregister() throws Exception {
        block6: {
            this.preDestruction();
            ObjectName[] names = this.children.keySet().toArray(new ObjectName[0]);
            for (int i = 0; i < names.length; ++i) {
                ObjectName child = names[i];
                try {
                    J2EEManagedObject.getMEJBUtility().unregisterMBean(child);
                    continue;
                }
                catch (MBSCAlreadyClosedException ex) {
                    continue;
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_JMX.JMX_17_LEVEL)) continue;
                    logger.log(JeusMessage_JMX.JMX_17_LEVEL, JeusMessage_JMX.JMX_17, (Object)child, (Throwable)ex);
                }
            }
            try {
                this.removeChildFromParent(this.myObjectName);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_JMX.JMX_18_LEVEL)) break block6;
                logger.log(JeusMessage_JMX.JMX_18_LEVEL, JeusMessage_JMX.JMX_18, (Object)this.myObjectName, (Throwable)ex);
            }
        }
    }

    private void removeChildFromParent(ObjectName objectName) throws IOException, ReflectionException, InstanceNotFoundException, MBeanException {
        block3: {
            if (this.parentObjectName != null) {
                try {
                    J2EEManagedObject.getMEJBUtility().invoke(this.parentObjectName, "removeChild", new Object[]{objectName}, new String[]{ObjectName.class.getName()});
                }
                catch (MBSCAlreadyClosedException ex) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "connection to the parent " + this.parentObjectName + " is closed during removing child, igore it", (Throwable)ex);
                }
            }
        }
    }

    protected abstract void postCreation(boolean var1) throws Exception;

    protected abstract void preDestruction() throws Exception;

    public void postDeregister() {
        this.mbs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification getNotificationObject(String event, ObjectName source, String message, Serializable userData) {
        long sequence;
        long timeStamp = System.currentTimeMillis();
        Object object = this.sequenceSync;
        synchronized (object) {
            sequence = this.sequenceNumber++;
        }
        J2eeNotificationImpl notification = new J2eeNotificationImpl(event, source, sequence, timeStamp, message);
        if (userData != null) {
            notification.setUserData(userData);
        }
        return notification;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        LoginUtil.checkPermissionWithRuntimeException(this.addListenerPermission);
        this.notificationDelegate.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        LoginUtil.checkPermissionWithRuntimeException(this.removeListenerPermission);
        this.notificationDelegate.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        LoginUtil.checkPermissionWithRuntimeException(this.removeListenerPermission);
        this.notificationDelegate.removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(String event, String message, Serializable userData) {
        Notification notification = this.getNotificationObject(event, this.myObjectName, message, userData);
        this.notificationDelegate.sendNotification(notification);
    }

    public boolean isDestroyed() {
        return this.mbs == null;
    }

    public void destroyMBean() {
        try {
            MBeanServer mbeanServer = this.mbs;
            if (mbeanServer != null && this.myObjectName != null) {
                if (logger.isLoggable(JeusMessage_JMX.JMX_19_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_19_LEVEL, JeusMessage_JMX.JMX_19, (Object)this.getCannonicalName(this.myObjectName));
                }
                mbeanServer.unregisterMBean(this.myObjectName);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            logger.log(JeusMessage_JMX.JMX_20_LEVEL, JeusMessage_JMX.JMX_20, (Object)this.getCannonicalName(this.myObjectName), (Throwable)e);
        }
    }

    public int getstate() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatePermission);
        return this.state;
    }

    public long getstartTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getstartTimePermission);
        return this.bootTime;
    }

    public void setStart(String message, Serializable userData) {
        if (this.state != 3 && this.state != 4) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_21, (Object[])new String[]{StateManageable.eventType[this.state], this.getCannonicalName(this.myObjectName)});
        }
        this.setState(0);
        this.sendNotification("j2ee.state.starting", message, userData);
    }

    public void setStopping(String message, Serializable userData) throws JMXManagerException {
        if (this.state != 1 && this.state != 0 && this.state != 4) {
            throw new JMXManagerException(JeusMessage_JMX.JMX_22, new String[]{StateManageable.eventType[this.state], this.getCannonicalName(this.myObjectName)});
        }
        this.setState(2);
        this.sendNotification("j2ee.state.stopping", message, userData);
    }

    public void stop() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.stopPermission);
        try {
            MBeanServerConnection mejbUtility = J2EEManagedObject.getMEJBUtility();
            this.setStopping(null, null);
            this.preStop();
            ObjectName[] i = this.getStateManageableChildren();
            for (int j = 0; j < i.length; ++j) {
                ObjectName j2eeSrvMoMBean = i[j];
                int serverState = (Integer)mejbUtility.getAttribute(j2eeSrvMoMBean, "state");
                if (serverState != 1 && serverState != 0) continue;
                mejbUtility.invoke(j2eeSrvMoMBean, "stop", dummyParam, dummySignature);
            }
            this.postStop();
            this.setStopped(null, null);
        }
        catch (Exception e) {
            this.setFailed(null, null);
            throw e;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected ObjectName[] getStateManageableChildren() {
        return this.stateManageableList.toArray(new ObjectName[0]);
    }

    public void addChild(ObjectName pChild) {
        try {
            this.children.put(pChild, JMXUtility.getProxy(J2EEManagedObject.getMEJBUtility(), pChild, J2EEManagedObjectMBean.class, false));
            if (((Boolean)J2EEManagedObject.getMEJBUtility().getAttribute(pChild, "stateManageable")).booleanValue()) {
                this.stateManageableList.add(pChild);
            }
        }
        catch (Throwable e) {
            logger.log(JeusMessage_JMX.JMX_14_LEVEL, JeusMessage_JMX.JMX_14, e);
        }
    }

    public void removeChild(ObjectName pChild) {
        this.children.remove(pChild);
        if (this.stateManageableList.contains(pChild)) {
            this.stateManageableList.remove(pChild);
        }
    }

    protected abstract void postStop() throws Exception;

    protected abstract void preStop() throws Exception;

    public void start() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.startPermission);
        try {
            this.setStart(null, null);
            this.preStart();
            this.postStart();
            this.setRunning(null, null);
        }
        catch (Exception e) {
            this.setFailed(null, null);
            throw e;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected abstract void postStart() throws Exception;

    protected abstract void preStart() throws Exception;

    public void setRunning(String message, Serializable userData) {
        this.setState(1);
        this.sendNotification("j2ee.state.running", message, userData);
    }

    protected void setFailed(String message, Serializable userData) {
        this.setState(4);
        this.sendNotification("j2ee.state.failed", message, userData);
    }

    public void startRecursive() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.startRecursivePermission);
        try {
            MBeanServerConnection mejbUtility = J2EEManagedObject.getMEJBUtility();
            this.setStart(null, null);
            this.preStart();
            ObjectName[] i = this.getStateManageableChildren();
            for (int j = 0; j < i.length; ++j) {
                ObjectName j2eeSrvMoMBean = i[j];
                int serverState = (Integer)mejbUtility.getAttribute(j2eeSrvMoMBean, "state");
                if (serverState != 3 && serverState != 4) continue;
                mejbUtility.invoke(j2eeSrvMoMBean, "startRecursive", dummyParam, dummySignature);
            }
            this.postStart();
            this.setRunning(null, null);
        }
        catch (Exception e) {
            this.setFailed(null, null);
            throw e;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void setStopped(String message, Serializable userData) {
        this.setState(3);
        this.sendNotification("j2ee.state.stopped", message, userData);
    }

    private void setState(int state) {
        this.state = state;
        if (logger.isLoggable(JeusMessage_JMX._79_LEVEL)) {
            logger.log(JeusMessage_JMX._79_LEVEL, JeusMessage_JMX._79, new Object[]{this.getStateString(state), this.getCannonicalName(this.myObjectName)});
        }
    }

    private String getStateString(int state) {
        if (state < 0 || state >= STATE_STRING.length) {
            return "unknown state " + state;
        }
        return STATE_STRING[state];
    }

    private String getCannonicalName(ObjectName objectName) {
        if (objectName == null) {
            return "null";
        }
        return objectName.toString();
    }

    private String getSimpleName(ObjectName objectName) {
        String key = objectName.getKeyProperty("jeusType");
        return key == null ? objectName.getKeyProperty("j2eeType") + "=" + objectName.getKeyProperty("name") : key + "=" + objectName.getKeyProperty("name");
    }

    protected NotificationBroadcasterSupport getNotificationBroadcasterSupport() {
        return this.notificationDelegate;
    }

    protected MBeanServer getRegisteredMBeanServer() {
        return this.mbs;
    }

    public static void setMEJBUtilityEnable() {
        isMEJBUtilityEnabled = true;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public String getJ2EEType() {
        return this.myObjectName.getKeyProperty("j2eeType");
    }

    public String getJeusType() {
        return this.myObjectName.getKeyProperty("jeusType");
    }

    public List getTroubles() {
        ArrayList troubleList = null;
        J2EEManagedObjectMBean[] childrenMBeans = this.children.values().toArray(dummyMBeanArray);
        for (int i = 0; i < childrenMBeans.length; ++i) {
            List list = childrenMBeans[i].getTroubles();
            if (list.size() <= 0) continue;
            if (troubleList == null) {
                troubleList = new ArrayList();
            }
            troubleList.addAll(list);
        }
        List list = this.getOwnTroubles();
        if (list.size() > 0) {
            if (troubleList == null) {
                troubleList = new ArrayList();
            }
            troubleList.addAll(list);
        }
        if (troubleList == null) {
            return Collections.EMPTY_LIST;
        }
        return troubleList;
    }

    public List getOwnTroubles() {
        if (this.monitorList.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Trouble> list = null;
        for (int i = 0; i < this.monitorList.length; ++i) {
            MonitorHandler monitorHandler = this.monitorList[i];
            Trouble trouble = monitorHandler.getStatus();
            if (trouble == null) continue;
            if (list == null) {
                list = new ArrayList<Trouble>();
            }
            list.add(trouble);
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    protected void setMonitorList(List monitorList) {
        this.monitorList = monitorList == null ? MonitorHandler.EMPTY_HANDLERS : monitorList.toArray(new MonitorHandler[monitorList.size()]);
    }

    public MonitorHandler getMonitorHandler(String warningKey, String fatalKey, DataProvider provider) {
        Properties p = TroubleMonitorDescriptor.getConstraints(this.myObjectName);
        if (p != null) {
            String warningRatio = null;
            String fatalRatio = null;
            if (warningKey != null) {
                warningRatio = p.getProperty(warningKey);
            }
            if (fatalKey != null) {
                fatalRatio = p.getProperty(fatalKey);
            }
            if (warningRatio != null || fatalRatio != null) {
                Trouble t = new Trouble();
                t.setObjectName(this.myObjectName);
                RatioMonitorHandler activeTroubleHandler = new RatioMonitorHandler(t, warningKey, fatalKey, provider);
                if (warningRatio != null) {
                    ((MonitorHandler)activeTroubleHandler).setWarningValue(warningRatio);
                }
                if (fatalRatio != null) {
                    ((MonitorHandler)activeTroubleHandler).setFatalValue(fatalRatio);
                }
                return activeTroubleHandler;
            }
        }
        return null;
    }

    protected String initDefaultPermission() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + this.myNameString;
    }

    protected List addHandler(List monitorList, String warningKey, String fatalKey, DataProvider provider) {
        MonitorHandler handler = this.getMonitorHandler(warningKey, fatalKey, provider);
        if (handler != null) {
            if (monitorList == null) {
                monitorList = new ArrayList<MonitorHandler>();
            }
            monitorList.add(handler);
        }
        return monitorList;
    }

    protected static Hashtable getObjectNameKeyTable(ObjectName objName, String[] parentKeyMap, String name, String j2eeType, String jeusType) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        for (int i = 0; i < parentKeyMap.length; ++i) {
            String s = parentKeyMap[i];
            String value = objName.getKeyProperty(s);
            if (value != null) {
                t.put(s, value);
                continue;
            }
            if (s.equals(objName.getKeyProperty("j2eeType")) || s.equals(objName.getKeyProperty("jeusType"))) {
                t.put(s, objName.getKeyProperty("name"));
                continue;
            }
            throw new RuntimeException("Invalid ObjectName " + objName + " for the parent key : " + s);
        }
        t.put("JMXManager", objName.getKeyProperty("JMXManager"));
        t.put("j2eeType", j2eeType);
        t.put("jeusType", jeusType);
        t.put("name", name);
        return t;
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    }
}

