/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.connector.ConnectorBootstrapContext;
import jeus.connector.ConnectorLogger;
import jeus.connector.ConnectorManagerException;
import jeus.connector.ConnectorUtility;
import jeus.connector.ManagedResourceAdapter;
import jeus.connector.work.WorkManager;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.InputJarArchive;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.J2EEServer;
import jeus.management.j2ee.JCAResource;
import jeus.management.j2ee.ResourceAdapter;
import jeus.management.j2ee.ResourceAdapterModuleMBean;
import jeus.management.j2ee.statistics.JCAWorkManagerStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.GTID;
import jeus.transaction.TMServer;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.file.FileUtils;
import jeus.xml.binding.connectorHelper.ConnectorPair;
import jeus.xml.binding.connectorHelper.WorkerPoolDescriptor;
import jeus.xml.binding.j2ee.ConfigPropertyType;
import jeus.xml.binding.jeusDD.ConnectorComponentType;
import jeus.xml.binding.jeusDD.SecurityPermissionType;

public class ResourceAdapterModule
extends J2EEModule
implements ResourceAdapterModuleMBean {
    private static final Hashtable resourceAdapters = new Hashtable();
    private static LinkedList recovered = new LinkedList();
    private ConnectorComponentType target;
    private FileArchive rarHomeArchive;
    private Vector adapters;
    private boolean isStandaloneDeploy;
    private ArrayList jarArchives;
    private String moduleName;
    private String loaderModuleName;
    private ResourceAdapter adapter;
    private ManagedResourceAdapter mra;
    private JCAWorkManagerStatsImpl workStats;
    private WorkManager wm;
    private ConnectorPair desc;
    private static final PermissionCollection defaultPermissions;
    private ResourcePermission poolControlPermission;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target, boolean standalone) throws InstanceAlreadyExistsException {
        ResourceAdapterModule object = new ResourceAdapterModule(parent, target, standalone);
        return object.createMBean(mBeanName, "ResourceAdapterModule", parent, parentKeyMap, null);
    }

    public ResourceAdapterModule(ObjectName parent, Object target, boolean standalone) {
        super(parent);
        this.target = (ConnectorComponentType)target;
        this.isStandaloneDeploy = standalone;
        this.jarArchives = new ArrayList();
        this.adapters = new Vector();
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        if (this.isStandaloneDeploy) {
            return parent.getPermissionName() + "." + "resource_adapter_module" + "." + this.myNameString;
        }
        return super.initPermissionName() + "." + "resource_adapter_module" + "." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.poolControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"poolControlPermision");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("--------------------------------------------------").append('\n');
        buf.append("ConnectorComponentType : ").append(this.target.toString()).append('\n');
        buf.append("FileArchive : ").append(this.rarHomeArchive.getArchiveUri()).append('\n');
        buf.append("path : ").append(this.path).append('\n');
        buf.append("moduleName : ").append(this.moduleName).append('\n');
        buf.append("loaderModuleName : ").append(this.loaderModuleName).append('\n').append('\n');
        return buf.toString();
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        this.adapters.add(pChild);
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        this.adapters.remove(pChild);
        super.removeChild(pChild);
    }

    public ObjectName[] getresourceAdaptors() {
        ObjectName[] names = new ObjectName[this.adapters.size()];
        return this.adapters.toArray(names);
    }

    public void setmin(int min) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setMin(min);
    }

    public void setmax(int max) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setMax(max);
    }

    public void setstep(int step) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setStep(step);
    }

    public void setkeepAliveTime(long time) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setKeepAliveTime(time);
    }

    public void setreleaseTimeout(long releaseTimeout) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setReleaseTimeout(releaseTimeout);
    }

    public void setrejectTimeout(long rejectTimeout) throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.poolControlPermission);
        this.wm.setRejectTimeout(rejectTimeout);
    }

    public int getmax() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getMax();
    }

    public int getmin() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getMin();
    }

    public int getstep() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getStep();
    }

    public long getkeepAliveTime() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getKeepAliveTime();
    }

    public long getreleaseTimeout() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getReleaseTimeout();
    }

    public long getrejectTimeout() throws Exception {
        if (this.wm == null) {
            throw new ResourceException("work manager is not activated");
        }
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.wm.getRejectTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID deploy(Object nill) throws Exception {
        this.isDeployed = true;
        this.moduleName = this.desc.getModuleName();
        this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
        this.pushDeploymentContext();
        try {
            javax.resource.spi.ResourceAdapter ra = this.setupResourceAdapter(this.desc);
            if (ra != null) {
                this.mra = new ManagedResourceAdapter(this.desc, ra, this.appClassLoader);
            }
            Hashtable hashtable = resourceAdapters;
            synchronized (hashtable) {
                if (resourceAdapters.containsKey(this.moduleName)) {
                    throw new Exception("Invalid module name : " + this.moduleName);
                }
                resourceAdapters.put(this.moduleName, this);
            }
            this.adapter = (ResourceAdapter)ResourceAdapter.createMBean(this.loaderModuleName, this.myObjectName, ra, this.moduleName, this.desc, this.appName, this.appClassLoader, this.isStandaloneDeploy);
            this.adapter.deploy();
        }
        finally {
            this.popDeploymentContext();
        }
        return this.myModuleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployInternal(long gracefulTimeout) throws Exception {
        block12: {
            try {
                resourceAdapters.remove(this.moduleName);
                this.adapter.undeploy();
                this.adapter = null;
                if (this.mra != null) {
                    this.mra.stop();
                }
                Object var4_2 = null;
                if (!this.isStandaloneDeploy) break block12;
                if (!this.isIsolatedClassloading) {
                    EngineContainer.rootClassLoader.remove(this.loaderModuleName);
                    break block12;
                }
                ((ArchiveArrayClassLoader)this.appClassLoader).clear();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (this.isStandaloneDeploy) {
                    if (!this.isIsolatedClassloading) {
                        EngineContainer.rootClassLoader.remove(this.loaderModuleName);
                    } else {
                        ((ArchiveArrayClassLoader)this.appClassLoader).clear();
                    }
                }
                for (int i = 0; i < this.jarArchives.size(); ++i) {
                    InputJarArchive jar = (InputJarArchive)this.jarArchives.get(i);
                    try {
                        if (jar == null) continue;
                        jar.close();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                this.jarArchives.clear();
                throw throwable;
            }
        }
        for (int i = 0; i < this.jarArchives.size(); ++i) {
            InputJarArchive jar = (InputJarArchive)this.jarArchives.get(i);
            try {
                if (jar == null) continue;
                jar.close();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        {
        }
        this.jarArchives.clear();
    }

    public PermissionCollection getDefaultPermissions() {
        return defaultPermissions;
    }

    public ClassLoader getClassLoader() {
        return this.appClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.startPermission);
        try {
            this.startRecursive();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void preStart() throws Exception {
        if (this.mra != null) {
            WorkerPoolDescriptor wmDesc = this.desc.getWorkManagerDesc();
            if (wmDesc != null) {
                this.workStats = new JCAWorkManagerStatsImpl();
                this.wm = new WorkManager(wmDesc);
                this.wm.init(this.workStats);
            }
            BootstrapContext ctx = ConnectorBootstrapContext.getContext(this.wm);
            this.mra.start(ctx);
            ConnectorLogger logger = new ConnectorLogger(this.moduleName);
            this.mra.setLogger(logger);
            ActivationSpec[] specs = logger.checkRecovered();
            if (specs.length != 0) {
                this.doRecovery(specs);
            }
        }
    }

    private void doRecovery(ActivationSpec[] specs) {
        XAResource[] resources;
        try {
            resources = this.mra.getXAResources(specs);
            if (resources == null) {
                this.mra.completeRecovery();
                return;
            }
        }
        catch (ResourceException re) {
            re.printStackTrace();
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            try {
                Xid[] xids = resources[i].recover(0x1000000);
                if (xids == null) {
                    this.mra.completeRecovery();
                    continue;
                }
                for (int j = 0; j < xids.length; ++j) {
                    byte[] bgtid = xids[j].getGlobalTransactionId();
                    GTID gtid = new GTID(bgtid);
                    byte decision = TMServer.getDecisionForUncompletedTx(gtid.getLTID(), gtid.getTime());
                    if (decision == 1) {
                        resources[i].rollback(xids[j]);
                        continue;
                    }
                    if (decision != 0) continue;
                    resources[i].commit(xids[j], false);
                }
                continue;
            }
            catch (XAException xae) {
                xae.printStackTrace();
                return;
            }
        }
        this.mra.completeRecovery();
    }

    protected void preStop() throws Exception {
        if (this.mra != null) {
            this.mra.stop();
        }
    }

    private javax.resource.spi.ResourceAdapter setupResourceAdapter(ConnectorPair desc) throws Exception {
        javax.resource.spi.ResourceAdapter ra = null;
        String raClassName = desc.getResourceAdapterClass();
        if (raClassName != null) {
            try {
                Class[] argTypes = new Class[1];
                Object[] args = new Object[1];
                Class<?> cl = this.appClassLoader.loadClass(raClassName);
                ra = (javax.resource.spi.ResourceAdapter)cl.newInstance();
                List raProperties = desc.getResourceAdapterProperty();
                for (ConfigPropertyType property : raProperties) {
                    if (property.getConfigPropertyType() == null || property.getConfigPropertyValue() == null) continue;
                    argTypes[0] = ConnectorUtility.getPropertyType(property.getConfigPropertyType().getValue());
                    args[0] = ConnectorUtility.getPropertyValue(argTypes[0], property.getConfigPropertyValue().getValue());
                    String name = property.getConfigPropertyName().getValue();
                    name = name.substring(0, 1).toUpperCase() + name.substring(1);
                    try {
                        ConnectorUtility.invokeMethod(cl, "set" + name, argTypes, ra, args);
                    }
                    catch (Throwable th) {
                        argTypes[0] = ConnectorUtility.getWrapperClass(argTypes[0]);
                        ConnectorUtility.invokeMethod(cl, "set" + name, argTypes, ra, args);
                    }
                }
            }
            catch (Exception cne) {
                cne.printStackTrace();
                throw new Exception(cne.getMessage());
            }
        }
        return ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List extract() throws IOException {
        FileArchive appRoot = J2EEServer.getAppRootArchive(this.path);
        try {
            String uri = this.target.getUri();
            if (FileUtils.isExploded((String)appRoot.getArchiveUri(), (String)uri)) {
                this.deployRARExploded(uri, appRoot);
            } else {
                this.deployRAR(uri, appRoot);
            }
        }
        finally {
            appRoot.close();
        }
        return this.jarArchives;
    }

    public boolean isStandaloneDeploy() {
        return this.isStandaloneDeploy;
    }

    public ModuleTypeSerializable getModuleType() {
        return ModuleTypeSerializable.RAR;
    }

    private void makeComponentClassLoader() throws JeusException {
        if (this.isStandaloneDeploy) {
            AbstractArchive[] adapterArchives = this.jarArchives.toArray(AbstractArchive.nullArray);
            if (System.getSecurityManager() != null) {
                ArrayList permissionsList = new ArrayList();
                try {
                    SecurityPermissionType permissionType = this.appType.getJavaSecurityPermission();
                    if (permissionType != null) {
                        this.addDescPermission(permissionType.getSecurityPermissionSpec(), permissionsList);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    List securitySpecs = this.desc.getJavaSecurityPermission();
                    for (String spec : securitySpecs) {
                        this.addDescPermission(spec, permissionsList);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                PermissionCollection permissions = this.getPermissions(permissionsList, (ClassLoader)EngineContainer.rootClassLoader);
                for (int i = 0; i < adapterArchives.length; ++i) {
                    AbstractArchive loaderArchive = adapterArchives[i];
                    loaderArchive.setCodeSource(this.codeSource);
                    loaderArchive.setPermissionCollection(permissions);
                }
            }
            ArchiveArrayClassLoader loader = ArchiveArrayClassLoader.createClassLoader(adapterArchives, EngineContainer.rootClassLoader, this.isIsolatedClassloading, this.loaderModuleName);
            this.appClassLoader = loader;
            try {
                loader.loadAllClasses();
            }
            catch (Throwable t) {
                throw new JeusException("Exception", t);
            }
            if (!this.isIsolatedClassloading) {
                EJBRootClassLoader.reloadWebContainer();
            }
        }
    }

    protected void deployRAR(String uri, FileArchive earHomeArchive) throws IOException {
        try {
            String fileHome = uri.substring(0, uri.lastIndexOf(".rar"));
            earHomeArchive.deleteEntry(fileHome);
            ArchiveHelper.extractArchive((FileArchive)earHomeArchive, (String)uri, (String)".rar");
            System.out.println(" -- exploded " + uri + ".rar");
            this.deployRARExploded(fileHome, earHomeArchive);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RemoteException("Exception occurred", e);
        }
    }

    protected void deployRARExploded(String fileHome, FileArchive earHomeArchive) throws IOException {
        this.loaderModuleName = fileHome;
        try {
            this.rarHomeArchive = (FileArchive)earHomeArchive.getEmbeddedArchive(fileHome);
            this.setRootArchive(this.rarHomeArchive);
            Enumeration enum1 = this.rarHomeArchive.entries();
            while (enum1.hasMoreElements()) {
                String entry = (String)enum1.nextElement();
                int index = entry.lastIndexOf(".jar");
                if (index < 0) continue;
                InputJarArchive embeddedJarArchive = this.rarHomeArchive.getEmbeddedJarArchive(entry);
                this.jarArchives.add(embeddedJarArchive);
            }
            this.desc = ConnectorPair.getDescriptor(this.rarHomeArchive, this.loaderModuleName);
            this.makeComponentClassLoader();
        }
        catch (Exception e) {
            if (!this.isStandaloneDeploy || this.isIsolatedClassloading) {
                for (int i = 0; i < this.jarArchives.size(); ++i) {
                    InputJarArchive inputJarArchive = (InputJarArchive)this.jarArchives.get(i);
                    try {
                        if (inputJarArchive == null) continue;
                        inputJarArchive.close();
                        continue;
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this.rarHomeArchive != null) {
                    this.rarHomeArchive.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            e.printStackTrace();
            throw new RemoteException("Exception occurred", e);
        }
    }

    public static javax.resource.spi.ResourceAdapter getResourceAdapter(String moduleName) throws ResourceException {
        ResourceAdapterModule ram = (ResourceAdapterModule)resourceAdapters.get(moduleName);
        javax.resource.spi.ResourceAdapter ra = ram.getManagedResourceAdapter();
        if (ra == null) {
            throw new ResourceException("Invalid module name : " + moduleName);
        }
        return ra;
    }

    private javax.resource.spi.ResourceAdapter getManagedResourceAdapter() {
        return this.mra;
    }

    public static synchronized void addRecoveredReference(Reference ref) {
        recovered.add(ref);
    }

    public static synchronized Vector getRecoveredReference(String moduleName) {
        Vector<Reference> v = new Vector<Reference>();
        Iterator it = recovered.iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            if (!moduleName.equals(ref.get(0))) continue;
            v.add(ref);
            it.remove();
        }
        return v;
    }

    private JCAResource getJcaResource() {
        return this.adapter.getjcaResource();
    }

    public static JCAResource getJCAResource(String moduleName) {
        ResourceAdapterModule ram = (ResourceAdapterModule)resourceAdapters.get(moduleName);
        if (ram == null) {
            return null;
        }
        return ram.getJcaResource();
    }

    public static void resyncCM(String moduleName, String exportName) throws ConnectorManagerException {
        JCAResource jca = ResourceAdapterModule.getJCAResource(moduleName);
        if (jca == null) {
            throw new ConnectorManagerException("Invalid module name : " + moduleName);
        }
        try {
            jca.resyncCM(exportName);
        }
        catch (Throwable t) {
            throw new ConnectorManagerException(t.getMessage());
        }
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.workStats;
    }

    public void setComponentType(Object deployDesc) {
    }

    public Object getComponentType() {
        return this.target;
    }

    static {
        try {
            defaultPermissions = Policy.getPolicy().getPermissions(new CodeSource(new URL("file:/jeus/connector/"), (Certificate[])null));
        }
        catch (MalformedURLException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }
}

