/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.monitor;

import jeus.management.j2ee.monitor.DataProvider;
import jeus.management.j2ee.monitor.MonitorHandler;
import jeus.management.j2ee.tmonitor.Trouble;
import jeus.management.j2ee.tmonitor.TroubleStatus;
import jeus.util.JeusRuntimeException;

public class RatioMonitorHandler
extends MonitorHandler {
    float warningRatio = -1.0f;
    float fatalRatio = -1.0f;
    private DataProvider provider;
    private Trouble trouble;
    private float ratio;
    private String warningKey;
    private String fatalKey;

    public RatioMonitorHandler(Trouble t, String warningKey, String fatalKey, DataProvider provider) {
        this.trouble = t;
        this.provider = provider;
        this.warningKey = warningKey;
        this.fatalKey = fatalKey;
    }

    public void setWarningValue(Object value) {
        this.warningRatio = Float.parseFloat((String)value);
    }

    public void setFatalValue(Object value) {
        this.fatalRatio = Float.parseFloat((String)value);
    }

    public Object getWarningValue() {
        return new Float(this.warningRatio);
    }

    public Object getFatalValue() {
        return new Float(this.fatalRatio);
    }

    public synchronized Trouble getStatus() {
        this.ratio = ((Float)this.provider.getMonitorValue()).floatValue();
        if (this.ratio > this.fatalRatio) {
            Trouble t = this.makeTroubleObj();
            t.setStatus(TroubleStatus.FATAL);
            t.setConstraintKey(this.fatalKey);
            t.setCause(this.provider.getFatalCause(this));
            return t;
        }
        if (this.ratio > this.warningRatio) {
            Trouble t = this.makeTroubleObj();
            t.setStatus(TroubleStatus.WARNING);
            t.setConstraintKey(this.warningKey);
            t.setCause(this.provider.getWarningCause(this));
            return t;
        }
        return null;
    }

    private Trouble makeTroubleObj() {
        Trouble t = null;
        try {
            t = (Trouble)this.trouble.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        return t;
    }

    public Object getObservedValue() {
        return new Float(this.ratio);
    }
}

