/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.security;

import java.security.Permission;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.base.Domain;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.util.Constants;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public class PolicyMo
extends J2EEManagedObjectSupport
implements PolicyMoMBean {
    private AuthorizationRepositoryService target;
    private ResourcePermission policyPermission;
    private String domainName;

    public PolicyMo(ObjectName parent, Object target) {
        super(parent);
        this.target = (AuthorizationRepositoryService)target;
        this.domainName = this.target.getDomain().getName();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        PolicyMo object = new PolicyMo(parent, target);
        return object.createMBean(mBeanName, "JeusService", parent, PolicyMoMBean.parentKeyMap, "SecurityPolicy");
    }

    public Stats getstats() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPolicyIds() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Set set = AuthorizationRepositoryService.getPolicyIds(this.target.getDomain());
            return set;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy getPolicy(String id) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Policy policy = AuthorizationRepositoryService.getPolicy(this.target.getDomain(), id);
            return policy;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolicy(Policy policy) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.addPolicy(this.target.getDomain(), policy);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolicy(Policy policy, boolean localAdd) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.addPolicy(this.target.getDomain(), policy, localAdd);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePolicy(Policy policy, boolean localRemove) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.removePolicy(this.target.getDomain(), policy, localRemove);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePolicy(Policy policy) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.removePolicy(this.target.getDomain(), policy);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePolicy(String contextId, boolean localRemove) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.removePolicy(this.target.getDomain(), contextId, localRemove);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePolicy(String contextId) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthorizationRepositoryService.removePolicy(this.target.getDomain(), contextId);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    public void save() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        AuthorizationRepositoryService.save(this.target.getDomain());
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".policy";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.policyPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"policyControl");
    }

    public Object readPoliciesInRepository() throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        return AuthorizationRepositoryService.readPolicy(this.target.getDomain());
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        AuthorizationRepositoryService.writePolicy(this.target.getDomain(), policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorizeResource(String resource, String action, String contextid) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            String classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
            Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)action);
            LoginService.checkPermission(contextid, p);
            boolean bl = true;
            return bl;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorizeRole(String role, String contextid) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.policyPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            String classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
            Permission p = PermissionMaker.makePermission((String)classname, (String)role, null);
            LoginService.checkPermission(contextid, p);
            boolean bl = true;
            return bl;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }
}

