/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.security;

import java.security.Permission;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.security.SecurityDomainMoMBean;
import jeus.security.base.Domain;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public class SecurityDomainMo
extends J2EEManagedObjectSupport
implements SecurityDomainMoMBean {
    private Domain target;
    private ResourcePermission securityDomainPermission;
    private Vector policys = new Vector();
    private Vector subjects = new Vector();

    public SecurityDomainMo(ObjectName parent, Object target) {
        super(parent);
        this.target = (Domain)target;
    }

    public Stats getstats() {
        return null;
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SecurityDomainMo object = new SecurityDomainMo(parent, target);
        return object.createMBean(mBeanName, "JeusService", parent, SecurityDomainMoMBean.parentKeyMap, "SecurityDomain");
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("SecurityPolicy")) {
            this.policys.add(pChild);
            super.addChild(pChild);
        } else if (lType.equals("SecuritySubject")) {
            this.subjects.add(pChild);
            super.addChild(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("SecurityPolicy")) {
            this.policys.remove(pChild);
            super.removeChild(pChild);
        } else if (lType.equals("SecuritySubject")) {
            this.subjects.remove(pChild);
            super.removeChild(pChild);
        }
    }

    public String[] getPolicys() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityDomainPermission);
        return JMXUtility.getAsStringArray(this.policys);
    }

    public String[] getSubjects() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityDomainPermission);
        return JMXUtility.getAsStringArray(this.subjects);
    }

    public String getDomainName() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.securityDomainPermission);
        return this.target.getName();
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + this.target.getName();
    }

    protected void makePermissions() {
        super.makePermissions();
        this.securityDomainPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"securityDomainControl");
    }
}

