/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.servlet.SessionRouterMoMBean;
import jeus.management.j2ee.servlet.SessionRouterStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.central.CentralSessionServerInfo;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.DistributedRouter;
import jeus.sessionmanager.distributed.DistributedSessionMonitoring;
import jeus.sessionmanager.distributed.DistributedSessionServerInfo;

public class SessionRouterMo
extends J2EEManagedObjectSupport
implements SessionRouterMoMBean {
    private DistributedSessionMonitoring target;
    private DistributedManagerConfig desc;
    private DistributedRouter router;
    private SessionRouterStatsImpl srStats;
    private ResourcePermission sessionContainerInfoPermission;
    private ResourcePermission sessionContainerControlPermission;

    public SessionRouterMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (DistributedSessionMonitoring)target;
        this.desc = (DistributedManagerConfig)((SessionManager)target).getManagerConfig();
        this.router = (DistributedRouter)((SessionManager)target).getRouter();
        this.srStats = new SessionRouterStatsImpl();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        mBeanName = mBeanName.replace(':', '_');
        SessionRouterMo object = new SessionRouterMo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "SessionContainerP2P");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".sessionContainer." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.sessionContainerInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"sessionContainerInfo");
        this.sessionContainerControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"sessionContainerControl");
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.target.updateStats(this.srStats);
    }

    public CentralSessionServerInfo getCentralServerInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return null;
    }

    public DistributedSessionServerInfo getDistributedServerInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.getServerInfo();
    }

    public boolean isExist(String key) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.isExist(key);
    }

    public ArrayList getLocalSessionKeys() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.getLocalSessionKeys();
    }

    public boolean invalidateSession(String id) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        return this.target.invalidateSession(id);
    }

    public int getContainerType() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return 3;
    }

    public Hashtable getP2PConnectionStatus() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.getConnectionStatus();
    }

    public String getbackupName() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.router.getBackup();
    }

    public int getbackupTrigger() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.desc.getBackupTrigger();
    }

    public long getcheckTo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.desc.getBackupCheckTo();
    }

    public long getconnectionTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.desc.getConnectTimeout();
    }

    public long getreadTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.desc.getReadTimeout();
    }

    public String getRouterName() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.router.getPrimary();
    }

    public void setbackupTrigger(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        this.desc.setBackupTrigger(value);
    }

    public void setcheckTo(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        this.desc.setBackupCheckTo(value);
    }

    public void setconnectionTimeout(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        this.desc.setConnectTimeout(value);
    }

    public void setreadTimeout(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        this.desc.setReadTimeout(value);
    }

    public long getpassivationTo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        if (!this.desc.useFile()) {
            return -1L;
        }
        return this.desc.getFilePassivationTo();
    }

    public void setpassivationTo(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        if (!this.desc.useFile()) {
            return;
        }
        this.desc.setFilePassivationTo(value);
    }
}

