/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.management.j2ee.servlet.SessionRouterStats;
import jeus.management.j2ee.statistics.CountStatisticImpl;

public class SessionRouterStatsImpl
extends SessionContainerStatsImpl
implements SessionRouterStats {
    public static final String PASSIVATED_SESSION_COUNT = "PassivatedSessionCount";
    public static final String LOCAL_FILEDB_SIZE = "LocalFileDbSize";
    public static final String BACKUP_SESSION_COUNT = "BackupSessionCount";
    public static final String PASSIVATED_BACKUP_SESSION_COUNT = "PassivatedBackupSessionCount";
    public static final String BACKUP_FILEDB_SIZE = "BackupFileDbSize";
    public static final String CONNECTION_COUNT = "ConnectionCount";

    public SessionRouterStatsImpl() {
        this.createPassivatedSessionCount();
        this.createLocalFileDbSize();
        this.createBackupSessionCount();
        this.createPassivatedBackupSessionCount();
        this.createBackupFileDbSize();
        this.createConnectionCount();
    }

    private CountStatisticImpl createPassivatedSessionCount() {
        CountStatisticImpl stat = new CountStatisticImpl(PASSIVATED_SESSION_COUNT, "count", "the number of passivated sessions");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    public CountStatistic getLocalFileDbSize() {
        return (CountStatisticImpl)this.getStatistic(LOCAL_FILEDB_SIZE);
    }

    private CountStatisticImpl createLocalFileDbSize() {
        CountStatisticImpl stat = new CountStatisticImpl(LOCAL_FILEDB_SIZE, "count", "size of local file-db");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    public CountStatistic getPassivatedSessionCount() {
        return (CountStatisticImpl)this.getStatistic(PASSIVATED_SESSION_COUNT);
    }

    private CountStatisticImpl createBackupSessionCount() {
        CountStatisticImpl stat = new CountStatisticImpl(BACKUP_SESSION_COUNT, "count", "the number of backup sessions");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    public CountStatistic getBackupSessionCount() {
        return (CountStatisticImpl)this.getStatistic(BACKUP_SESSION_COUNT);
    }

    private CountStatisticImpl createPassivatedBackupSessionCount() {
        CountStatisticImpl stat = new CountStatisticImpl(PASSIVATED_BACKUP_SESSION_COUNT, "count", "the number of passivated backup sessions");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    public CountStatistic getPassivatedBackupSessionCount() {
        return (CountStatisticImpl)this.getStatistic(PASSIVATED_BACKUP_SESSION_COUNT);
    }

    public CountStatistic getBackupFileDbSize() {
        return (CountStatisticImpl)this.getStatistic(BACKUP_FILEDB_SIZE);
    }

    private CountStatisticImpl createBackupFileDbSize() {
        CountStatisticImpl stat = new CountStatisticImpl(BACKUP_FILEDB_SIZE, "count", "size of backup file-db");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    private CountStatisticImpl createConnectionCount() {
        CountStatisticImpl stat = new CountStatisticImpl(CONNECTION_COUNT, "count", "the number of current socket connections");
        this.setStatistic((Statistic)stat);
        return stat;
    }

    public CountStatistic getConnectionCount() {
        return (CountStatisticImpl)this.getStatistic(CONNECTION_COUNT);
    }
}

