/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.security.Permission;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.deployment.descriptor.ThreadStateNotifyDescriptor;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobThreadPoolManager;

public class ThreadPoolMo
extends J2EEManagedObjectSupport
implements ThreadPoolMoMBean {
    private ThreadPoolManager target;
    private ThreadPoolStatsImpl thPoolStats;
    private ResourcePermission threadPoolInfoPermission;
    private ResourcePermission threadPoolControlPermission;

    public ThreadPoolMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (ThreadPoolManager)target;
        this.thPoolStats = new ThreadPoolStatsImpl();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ThreadPoolMo object = new ThreadPoolMo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "ThreadPool_WEBC");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".threadPool." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.threadPoolInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"threadPoolInfo");
        this.threadPoolControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"threadPoolControl");
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.target.updateStats(this.thPoolStats);
    }

    public void clearStats() {
        this.target.clearStats();
    }

    public Vector getThreadState_ALL_INFO() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadState(ThreadStateInfo.GET_ALL_INFO);
    }

    public Vector getThreadState(int mode) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadState(mode);
    }

    protected void preStart() throws Exception {
        if (this.target instanceof WebtobThreadPoolManager) {
            ((WebtobThreadPoolManager)this.target).resume();
        }
    }

    protected void preStop() throws Exception {
        if (this.target instanceof WebtobThreadPoolManager) {
            ((WebtobThreadPoolManager)this.target).suspend();
        }
    }

    public int getmax() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getMaxThreadNum();
    }

    public long getmaxIdleTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getMaxIdleTime();
    }

    public int getmaxQueue() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getMaxQueue();
    }

    public int getmaxWaitQueue() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getMaxWaitQueue();
    }

    public int getmin() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getMinThreadNum();
    }

    public int getstep() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolInfoPermission);
        return this.target.getThreadPoolDescriptor().getChangingRate();
    }

    public void setmax(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        this.target.setMaxThreadNum("" + value);
    }

    public void setmaxIdleTime(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        this.target.setMaxIdleTime("" + value);
    }

    public void setmaxQueue(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        this.target.setMaxQueue("" + value);
    }

    public void setmaxWaitQueue(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        this.target.setMaxWaitQueue("" + value);
    }

    public void setmin(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        try {
            this.target.setMinThreadNum("" + value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setstep(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        this.target.setChangingRate("" + value);
    }

    public void setMaxThreadActiveTime(String value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            desc.setMaxThreadActiveTime(value);
        }
    }

    public void setNotifyThreshold(String value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            desc.setNotifyThreshold(value);
        }
    }

    public void setRestartThreshold(String value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            desc.setRestartThreshold(value);
        }
    }

    public String getMaxThreadActiveTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            return String.valueOf(desc.getMaxThreadActiveTime());
        }
        return "-1";
    }

    public String getNotifyThreshold() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            return desc.getNotifyThreshold();
        }
        return "-1";
    }

    public String getRestartThreshold() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolControlPermission);
        ThreadStateNotifyDescriptor desc = this.target.getThreadStateNotifyDescriptor();
        if (desc != null) {
            return desc.getRestartThreshold();
        }
        return "-1";
    }
}

