/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.security.Permission;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.servlet.connection.Connector;
import jeus.servlet.connection.WebtobConnector;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobThreadPoolManager;

public class WebListenerMo
extends J2EEManagedObjectSupport
implements WebListenerMoMBean {
    private Connector target;
    private ConnectionDescriptor desc;
    private String type;
    private Vector threadPools = new Vector();
    private ResourcePermission webListenerInfoPermission;
    private ResourcePermission webListenerControlPermission;

    public WebListenerMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (Connector)target;
        this.desc = this.target.getConnectionDescriptor();
    }

    public String[] getThreadPools() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return JMXUtility.getAsStringArray(this.threadPools);
    }

    public ObjectName getPoolByName(String poolId) {
        Enumeration enum1 = this.threadPools.elements();
        while (enum1.hasMoreElements()) {
            ObjectName objName = (ObjectName)enum1.nextElement();
            if (!objName.getKeyProperty("name").equals(poolId)) continue;
            return objName;
        }
        return null;
    }

    public String getType() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return this.type;
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target, String _type) throws InstanceAlreadyExistsException {
        WebListenerMo object = new WebListenerMo(target, parent);
        object.setType(_type);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "WebListener");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".webListener." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webListenerInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webListenerInfo");
        this.webListenerControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"webListenerControl");
    }

    public void setType(String _type) {
        this.type = _type;
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        this.threadPools.add(pChild);
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        this.threadPools.remove(pChild);
        super.removeChild(pChild);
    }

    public int getPort() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return this.target.getPort();
    }

    public boolean isSecure() {
        return this.desc.isEnableSecure();
    }

    protected void preStart() throws Exception {
        if (this.target instanceof WebtobConnector) {
            ThreadPoolManager[] tpools = this.target.getThreadPoolManager();
            for (int i = 0; i < tpools.length; ++i) {
                WebtobThreadPoolManager tpm = (WebtobThreadPoolManager)tpools[i];
                tpm.resume();
            }
        }
    }

    protected void preStop() throws Exception {
        if (this.target instanceof WebtobConnector) {
            ThreadPoolManager[] tpools = this.target.getThreadPoolManager();
            for (int i = 0; i < tpools.length; ++i) {
                WebtobThreadPoolManager tpm = (WebtobThreadPoolManager)tpools[i];
                tpm.suspend();
            }
        }
    }

    public int getpostdataReadTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return this.desc.getPostdataReadTimeout();
    }

    public int getreadTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return this.desc.getReadTimeout();
    }

    public long getreconnectTimeout() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerInfoPermission);
        return this.desc.getReconnectTimeout();
    }

    public void setpostdataReadTimeout(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerControlPermission);
        this.desc.setPostdataReadTimeout("" + value);
    }

    public void setreadTimeout(int value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerControlPermission);
        this.desc.setReadTimeout("" + value);
    }

    public void setreconnectTimeout(long value) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.webListenerControlPermission);
        this.desc.setReconnectTimeout("" + value);
    }
}

