/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.transaction;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import jeus.transaction.TMServer;
import jeus.transaction.XAResourceFactory;

public class ReferenceInfo
implements Serializable {
    private XAResourceFactory ref;
    private transient Object handback;
    private Map pendingXids = new HashMap();
    private long recoverTime;
    private long startTime;
    private static final AtomicInteger idGen = new AtomicInteger(0);
    private int id;
    private String exportName;

    public ReferenceInfo() {
    }

    public ReferenceInfo(XAResourceFactory ref) {
        this.ref = ref;
    }

    public ReferenceInfo(XAResourceFactory ref, String exportName, Object handback, long startTime) {
        this(ref);
        this.exportName = exportName;
        this.id = idGen.incrementAndGet();
        this.handback = handback;
        this.startTime = startTime;
    }

    public void setPendingXids(Collection pendingXidArray) {
        this.pendingXids.clear();
        for (Xid xid : pendingXidArray) {
            this.pendingXids.put(xid, xid);
        }
        this.recoverTime = System.currentTimeMillis();
    }

    public Object getHandback() {
        return this.handback;
    }

    public long getUsedTime() {
        return this.startTime;
    }

    public Xid[] getPendingXids() {
        Set set = this.pendingXids.keySet();
        return set.toArray(new Xid[set.size()]);
    }

    public long getRecoverTime() {
        return this.recoverTime;
    }

    public XAResourceFactory getResourceReference() {
        return this.ref;
    }

    public void removePendingXid(Xid xid) {
        this.pendingXids.remove(xid);
        if (this.pendingXids.size() == 0) {
            TMServer.removeXAResourceInfo(this);
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceInfo) {
            return this.id == ((ReferenceInfo)obj).id;
        }
        return false;
    }

    public String getExportName() {
        return this.exportName;
    }
}

