/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.webserver;

import java.rmi.RemoteException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.management.j2ee.webserver.RemoteWebServerInfoMBean;
import jeus.management.j2ee.webserver.WebServerInfoStatsImpl;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.webserver.NodeDescriptor;
import jeus.webserver.RemoteWebServerProxyImpl;
import jeus.webserver.SvrDescriptor;

public class RemoteWebServerInfo
extends J2EEManagedObjectSupport
implements RemoteWebServerInfoMBean {
    private RemoteWebServerProxyImpl target;
    private WebServerInfoStatsImpl stats;
    private List mWSEngine = new ArrayList();
    private Permission webserverPermission;
    private boolean saveFlag = true;

    public RemoteWebServerInfo(Object target, ObjectName parent) {
        super(parent);
        this.stats = new WebServerInfoStatsImpl();
        this.target = (RemoteWebServerProxyImpl)target;
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".remotewebserver";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.webserverPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"remotewebserver");
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        RemoteWebServerInfo object = new RemoteWebServerInfo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "RemoteWebtob");
    }

    public void addChild(ObjectName objectname) {
        LoginService.checkCodeSubject();
        String s = JMXUtility.getJeusType(objectname);
        if ("RemoteWebtob".equals(s)) {
            this.mWSEngine.add(objectname);
            super.addChild(objectname);
        }
    }

    public void removeChild(ObjectName objectname) {
        LoginService.checkCodeSubject();
        String s = JMXUtility.getJeusType(objectname);
        if ("RemoteWebtob".equals(s)) {
            this.mWSEngine.remove(objectname);
            super.removeChild(objectname);
            this.saveFlag = true;
        }
    }

    public void setStatistic(StatisticImpl statistic) {
        this.stats.setStatistic((Statistic)statistic);
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        if (this.stats == null) {
            return null;
        }
        if (this.target != null) {
            try {
                SvrDescriptor[] svrdecs = this.target.getAllSvr();
                CountStatisticImpl svrCount = (CountStatisticImpl)this.stats.getSvrCount();
                CountStatisticImpl execCount = (CountStatisticImpl)this.stats.getExecCount();
                TimeStatisticImpl avgTime = (TimeStatisticImpl)this.stats.getAvgTime();
                for (int i = 0; i < svrdecs.length; ++i) {
                    SvrDescriptor desc = svrdecs[i];
                    svrCount.setValue((long)desc.getCount());
                    avgTime.addData((long)desc.getAvg());
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.stats;
    }

    public NodeDescriptor getNodeInfo() {
        LoginUtil.checkPermissionWithRuntimeException(this.webserverPermission);
        try {
            return this.target.getNodeDescriptor();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SvrDescriptor[] getSvrAllInfo() {
        LoginUtil.checkPermissionWithRuntimeException(this.webserverPermission);
        try {
            return this.target.getAllSvr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int wsdown() throws RemoteException {
        int result = this.target.wsdown();
        if (result == 0) {
            this.saveFlag = true;
        }
        return result;
    }

    public int wsboot() throws RemoteException {
        return this.target.wsboot();
    }

    public int compileConfig() {
        return this.target.compile_config();
    }

    public boolean isRunning() throws RemoteException {
        return this.target.wsRunning();
    }

    public static ObjectName makeObjectName(ObjectName objName, String name) throws MalformedObjectNameException {
        Hashtable t = RemoteWebServerInfo.getObjectNameKeyTable(objName, parentKeyMap, name, "JeusService", "RemoteWebtob");
        return new ObjectName("JEUS", t);
    }
}

