/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.adaptor;

import java.rmi.RemoteException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import jeus.management.snmp.agent.SnmpAgentForRMI;
import jeus.util.logging.JeusLogger;

public abstract class SnmpSupport {
    protected static SnmpAgentForRMI snmpAgent = null;
    protected static String MBEAN_NAME;
    protected static final JeusLogger logger;

    public boolean connectToSnmpAgent() {
        if (snmpAgent == null) {
            try {
                InitialContext initial = new InitialContext();
                snmpAgent = (SnmpAgentForRMI)initial.lookup("SnmpAgent");
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    public abstract void initialize() throws RemoteException;

    public void add(String oid, String attributeName) throws RemoteException {
        snmpAgent.addEventListener(MBEAN_NAME, oid);
        snmpAgent.putOID(oid + ".0", MBEAN_NAME, attributeName);
    }

    public void addObjectName(ObjectName objectName) throws RemoteException {
        snmpAgent.putObjectName(MBEAN_NAME, objectName);
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    }
}

