/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jeus.management.snmp.core.SecurityInterface;

public class Authenticator {
    MessageDigest md = null;
    byte[] extendedKey = null;

    public Authenticator(String s, byte[] abyte0) {
        if (abyte0.length > 63) {
            System.err.println(" key is too long.");
            return;
        }
        this.extendedKey = new byte[64];
        for (int i = 16; i < 64; ++i) {
            this.extendedKey[i] = 0;
        }
        for (int j = 0; j < abyte0.length; ++j) {
            this.extendedKey[j] = abyte0[j];
        }
        if (s.equals("MD5") || s.equals("SHA-1")) {
            try {
                this.md = MessageDigest.getInstance(s);
            }
            catch (NoSuchAlgorithmException nosuchalgorithmexception) {
                System.err.println(" ex. : " + nosuchalgorithmexception);
            }
        } else {
            System.err.println("algorithm " + s + " is unknown.");
        }
    }

    public byte[] doFinal(byte[] abyte0) {
        byte[] abyte1 = new byte[64];
        for (int i = 0; i < 64; ++i) {
            abyte1[i] = 54;
        }
        byte[] abyte2 = new byte[64];
        for (int j = 0; j < 64; ++j) {
            abyte2[j] = (byte)(abyte1[j] ^ this.extendedKey[j]);
        }
        byte[] abyte3 = new byte[64];
        for (int k = 0; k < 64; ++k) {
            abyte3[k] = 92;
        }
        byte[] abyte4 = new byte[64];
        for (int l = 0; l < 64; ++l) {
            abyte4[l] = (byte)(abyte3[l] ^ this.extendedKey[l]);
        }
        byte[] abyte5 = new byte[abyte0.length + abyte2.length];
        for (int i1 = 0; i1 < abyte0.length; ++i1) {
            abyte5[i1 + abyte2.length] = abyte0[i1];
        }
        for (int j1 = 0; j1 < abyte2.length; ++j1) {
            abyte5[j1] = abyte2[j1];
        }
        byte[] abyte6 = this.getDigest(abyte5);
        byte[] abyte7 = new byte[abyte6.length + abyte4.length];
        for (int k1 = 0; k1 < abyte4.length; ++k1) {
            abyte7[k1] = abyte4[k1];
        }
        for (int l1 = 0; l1 < abyte6.length; ++l1) {
            abyte7[l1 + abyte4.length] = abyte6[l1];
        }
        byte[] abyte8 = this.getDigest(abyte7);
        return abyte8;
    }

    public static boolean doSnmpAuthentication(byte[] abyte0, boolean flag, int i, byte[] abyte1, SecurityInterface securityinterface) {
        int l = 0;
        int j = Authenticator.getHeaderLength(abyte0, l);
        l += j;
        j = Authenticator.getHeaderLength(abyte0, l);
        int k = Authenticator.getDataLength(abyte0, l);
        if (abyte0[l + j] != 3) {
            return true;
        }
        int i1 = l += j + k;
        j = Authenticator.getHeaderLength(abyte0, l);
        k = Authenticator.getDataLength(abyte0, l);
        l += j + k;
        i1 += j;
        j = Authenticator.getHeaderLength(abyte0, i1);
        k = Authenticator.getDataLength(abyte0, i1);
        i1 += j + k;
        j = Authenticator.getHeaderLength(abyte0, i1);
        k = Authenticator.getDataLength(abyte0, i1);
        i1 += j + k;
        j = Authenticator.getHeaderLength(abyte0, i1);
        k = Authenticator.getDataLength(abyte0, i1);
        byte byte0 = abyte0[i1 + j];
        if ((byte0 & 1) == 0) {
            return true;
        }
        j = Authenticator.getHeaderLength(abyte0, l);
        l += j;
        j = Authenticator.getHeaderLength(abyte0, l);
        l += j;
        for (int j1 = 0; j1 < 3; ++j1) {
            j = Authenticator.getHeaderLength(abyte0, l);
            k = Authenticator.getDataLength(abyte0, l);
            l += j + k;
        }
        j = Authenticator.getHeaderLength(abyte0, l);
        k = Authenticator.getDataLength(abyte0, l);
        byte[] abyte2 = new byte[k];
        for (int k1 = 0; k1 < k; ++k1) {
            abyte2[k1] = abyte0[l + j + k1];
        }
        l += j + k;
        j = Authenticator.getHeaderLength(abyte0, l);
        k = Authenticator.getDataLength(abyte0, l);
        if (securityinterface == null && abyte1 == null && i == -1) {
            System.err.println("SecurityInterface implementation is missing.");
            return false;
        }
        if (abyte1 == null) {
            abyte1 = securityinterface.getAuthenticationPassword(abyte2);
        }
        if (abyte1 == null) {
            return false;
        }
        String s = null;
        if (i == -1) {
            i = securityinterface.getAuthenticationAlgorithm(abyte2);
        }
        s = i == 0 ? "MD5" : "SHA-1";
        Authenticator authenticator = new Authenticator(s, abyte1);
        if (flag) {
            byte[] abyte3 = authenticator.doSnmpDigest(abyte0);
            for (int l1 = 0; l1 < k; ++l1) {
                abyte0[l + j + l1] = abyte3[l1];
            }
        } else {
            byte[] abyte4 = new byte[k];
            for (int i2 = 0; i2 < k; ++i2) {
                abyte4[i2] = abyte0[l + j + i2];
                abyte0[l + j + i2] = 0;
            }
            byte[] abyte5 = authenticator.doSnmpDigest(abyte0);
            for (int j2 = 0; j2 < abyte4.length; ++j2) {
                if (abyte4[j2] == abyte5[j2]) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] doSnmpDigest(byte[] abyte0) {
        byte[] abyte1 = this.doFinal(abyte0);
        byte[] abyte2 = new byte[12];
        for (int i = 0; i < 12; ++i) {
            abyte2[i] = abyte1[i];
        }
        return abyte2;
    }

    public static int getDataLength(byte[] abyte0, int i) {
        int j = 0;
        byte byte0 = abyte0[i + 1];
        if ((0x80 & byte0) != 0) {
            int k = 0x7F & byte0;
            for (int l = 0; l < k; ++l) {
                int i1 = 0x7F & abyte0[i + 2 + l];
                if ((0x80 & abyte0[i + 2 + l]) != 0) {
                    i1 += 128;
                }
                j = (j << 8) + i1;
            }
        } else {
            j = 0x7F & byte0;
        }
        return j;
    }

    private byte[] getDigest(byte[] abyte0) {
        Object obj = null;
        if (this.md == null) {
            return null;
        }
        this.md.update(abyte0);
        byte[] abyte1 = this.md.digest();
        return abyte1;
    }

    public static int getHeaderLength(byte[] abyte0, int i) {
        int j = 0;
        byte byte0 = abyte0[i + 1];
        if ((0x80 & byte0) != 0) {
            int k = 0x7F & byte0;
            j = k + 1;
        } else {
            j = 1;
        }
        return j + 1;
    }

    public static void main(String[] args) {
        String s = "4444567890123456789012345678901234567890123456789012345678901234";
        if (args.length > 0) {
            s = args[0];
        }
        byte[] abyte0 = new byte[]{0, -1, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1};
        Authenticator authenticator = new Authenticator("SHA-1", abyte0);
        byte[] abyte1 = authenticator.doFinal(s.getBytes());
        System.out.println("digest length : " + abyte1.length);
        Authenticator.print(abyte1);
        abyte1 = authenticator.doSnmpDigest(s.getBytes());
        System.out.println("digest length : " + abyte1.length);
        Authenticator.print(abyte1);
    }

    static void print(byte[] abyte0) {
        for (int i = 0; i < abyte0.length; ++i) {
            System.out.print(" " + abyte0[i]);
        }
        System.out.println("");
    }
}

