/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.management.snmp.core.AsnFactory;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.Authenticator;
import jeus.management.snmp.core.LeafOIDListener;
import jeus.management.snmp.core.SecurityInterface;
import jeus.management.snmp.core.SnmpDispatcher;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessage;
import jeus.management.snmp.core.SnmpMessageEvent;
import jeus.management.snmp.core.SnmpServerListener;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;
import jeus.util.properties.JeusNetPropertyValues;

public class SnmpServer
extends Thread {
    public static int REPORT = 1;
    public static int TRAP_V1 = 2;
    public static int TRAP_V2 = 4;
    public static int INFORM = 8;
    protected static final boolean debug = false;
    protected DatagramSocket receive_socket = null;
    protected DatagramSocket send_socket = null;
    protected BufferedReader in = null;
    protected boolean moreReqs;
    protected boolean responde = false;
    protected static int defaultPort = 161;
    String registeredContextEngineID;
    SnmpDispatcher snmpDispatcher;
    protected Vector listeners;
    protected static final int TYPE_MODE = 0;
    protected static final int LEN_MODE = 1;
    protected static final int DATA_MODE = 2;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    private Executor pooledExecutor;
    private static final String THREAD_NAME_PREFIX = "SnmpServer";
    private JMXManagerDescriptor desc;
    private SnmpAgent snmpAgent;

    public SnmpServer(String s, String s1, int i, SnmpAgent snmpAgent) throws IOException {
        super(s1);
        this.snmpAgent = snmpAgent;
        this.snmpDispatcher = new SnmpDispatcher();
        this.listeners = new Vector();
        defaultPort = i;
        this.registeredContextEngineID = s;
        this.pooledExecutor = PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)10);
    }

    public SnmpServer(String s, String s1, int i, JMXManagerDescriptor desc, SnmpAgent snmpAgent) {
        super(s1);
        this.snmpAgent = snmpAgent;
        this.snmpDispatcher = new SnmpDispatcher();
        this.listeners = new Vector();
        defaultPort = i;
        this.registeredContextEngineID = s;
        this.desc = desc;
    }

    public void initialize(ObjectName parentName) throws InstanceAlreadyExistsException {
        if (this.pooledExecutor == null) {
            this.pooledExecutor = PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.desc.getSNMPPoolMax(), (int)this.desc.getSNMPPoolMin(), (long)this.desc.getSNMPPoolPeriod());
        }
    }

    public void addEventListener(LeafOIDListener leafoidlistener) {
        this.snmpDispatcher.addEventListener(leafoidlistener);
    }

    public void removeEventListener(String oid, String uniqueId) {
        if (this.snmpDispatcher != null) {
            this.snmpDispatcher.removeEventListener(oid, uniqueId);
        }
    }

    public void addSnmpSecurityInterface(SecurityInterface securityinterface) {
        this.snmpDispatcher.addSnmpSecurityInterface(securityinterface);
    }

    public void addSnmpServerListener(SnmpServerListener snmpserverlistener, int i) {
        this.snmpDispatcher.addEventListener(snmpserverlistener, i);
    }

    public int getDefaultPort() {
        return defaultPort;
    }

    protected void notifyListeners(SnmpMessageEvent snmpmessageevent) {
        SnmpMessage snmpmessage = snmpmessageevent.getSnmpMessage();
        if (snmpmessage.discoveryPhase) {
            snmpmessage.getPdu().setMsgType((byte)-88);
        } else if (snmpmessage.errorStatus != 0) {
            if (!snmpmessage.isReportRequired()) {
                return;
            }
            int i = 0;
            String s = snmpmessage.secFailureReason;
            if (s != null) {
                i = this.snmpDispatcher.security.getStats(s);
            }
            SnmpGetSetPdu snmpgetsetpdu = new SnmpGetSetPdu();
            snmpgetsetpdu.setErrorStatus(snmpmessage.errorStatus);
            if (s != null) {
                AsnInteger asninteger = new AsnInteger(i);
                AsnNameValuePair asnnamevaluepair = new AsnNameValuePair(s, asninteger);
                snmpgetsetpdu.addNameValuePair(asnnamevaluepair);
            }
            snmpgetsetpdu.setMsgType((byte)-88);
            snmpmessage.setPdu(snmpgetsetpdu);
            if (s.equals("1.3.6.1.6.3.15.1.1.6") || s.equals("1.3.6.1.6.3.15.1.1.1")) {
                snmpmessage.setEncryptionMode(false);
            }
        } else if (snmpmessage.getSnmpVersion() != 3L || this.registeredContextEngineID.equals("*") || this.registeredContextEngineID.equals(new String(snmpmessage.getContextEngineID()))) {
            this.snmpDispatcher.notifyEvent(snmpmessageevent);
        }
        if (snmpmessage.getPdu().getMsgType() == -94 || snmpmessage.getPdu().getMsgType() == -88) {
            try {
                this.sendSnmpMessage(snmpmessageevent.getAddress(), snmpmessageevent.getPort(), snmpmessage);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    protected void printPacket(DatagramPacket datagrampacket) {
        System.out.println("DatagramPacket from " + datagrampacket.getAddress() + ":" + datagrampacket.getPort());
        System.out.println("-------------------------");
        byte[] abyte0 = datagrampacket.getData();
        Vector<StringBuffer> vector = new Vector<StringBuffer>();
        Vector<StringBuffer> vector1 = new Vector<StringBuffer>();
        StringBuffer stringbuffer = new StringBuffer();
        vector.addElement(stringbuffer);
        StringBuffer stringbuffer1 = new StringBuffer();
        vector1.addElement(stringbuffer1);
        for (int i = 0; i < datagrampacket.getLength(); ++i) {
            byte byte0 = abyte0[i];
            stringbuffer.append(AsnFactory.toHex(byte0) + ",");
            if (!Character.isWhitespace((char)byte0)) {
                stringbuffer1.append((char)byte0 + ",");
            } else {
                stringbuffer1.append(" ,");
            }
            if ((i + 1) % 8 != 0) continue;
            stringbuffer = new StringBuffer();
            vector.addElement(stringbuffer);
            stringbuffer1 = new StringBuffer();
            vector1.addElement(stringbuffer1);
        }
        for (int j = 0; j < vector.size(); ++j) {
            StringBuffer stringbuffer2 = (StringBuffer)vector.elementAt(j);
            StringBuffer stringbuffer3 = (StringBuffer)vector1.elementAt(j);
            System.out.println(stringbuffer2 + "    " + stringbuffer3);
        }
        System.out.println("-------------------------");
    }

    protected void printPacketDetails(DatagramPacket datagrampacket) {
        System.out.println("DatagramPacket from " + datagrampacket.getAddress() + ":" + datagrampacket.getPort());
        System.out.println("-------------------------");
        System.out.println("0x INT CHR INFO");
        System.out.println("-- --- --- --------------");
        byte[] abyte0 = datagrampacket.getData();
        int i = 0;
        boolean flag = false;
        long l = 0L;
        long l1 = 0L;
        block8: for (int j = 0; j < datagrampacket.getLength(); ++j) {
            byte k = abyte0[j];
            switch (i) {
                default: {
                    continue block8;
                }
                case 0: {
                    System.out.println(AsnFactory.toHex(k) + " " + this.threeChar(k) + " '" + (!Character.isISOControl((char)k) && !Character.isWhitespace((char)k) ? (char)k : (char)' ') + "' TYPE=" + AsnFactory.asnType2String(k));
                    switch (k) {
                        case -96: 
                        case -95: 
                        case -94: 
                        case -93: 
                        case -92: 
                        case -91: 
                        case 48: {
                            flag = true;
                            break;
                        }
                        default: {
                            flag = false;
                        }
                    }
                    i = 1;
                    continue block8;
                }
                case 1: {
                    l = k;
                    System.out.println(AsnFactory.toHex(k) + " " + this.threeChar(k) + " '" + (!Character.isISOControl((char)k) && !Character.isWhitespace((char)k) ? (char)k : (char)' ') + "' LEN =" + k);
                    if (flag) {
                        i = 0;
                        continue block8;
                    }
                    if (l == 0L) {
                        i = 0;
                        continue block8;
                    }
                    i = 2;
                    l1 = 0L;
                    continue block8;
                }
                case 2: {
                    System.out.println(AsnFactory.toHex(k) + " " + this.threeChar(k) + " '" + (!Character.isISOControl((char)k) && !Character.isWhitespace((char)k) ? (char)k : (char)' ') + "'");
                    if (++l1 < l) continue block8;
                    i = 0;
                }
            }
        }
        System.out.println("-------------------------");
    }

    public void cancel() throws Exception {
        this.moreReqs = false;
        if (this.send_socket == null) {
            return;
        }
        byte[] msg = "SNMP_AGENT_STOP_MSG".getBytes();
        this.send_socket.send(new DatagramPacket(msg, msg.length, JeusNetPropertyValues.getLocalInetAddress(), defaultPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.send_socket = this.receive_socket = new DatagramSocket(defaultPort);
            this.moreReqs = true;
        }
        catch (Throwable t) {
            this.moreReqs = false;
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_3_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_3_LEVEL, JeusMessage_SNMP.SNMP_3, t);
            }
            if (this.snmpAgent != null) {
                this.snmpAgent.stop();
            }
            return;
        }
        while (this.moreReqs) {
            try {
                byte[] abyte0 = new byte[AsnObject.MAX_PACKET_SIZE];
                DatagramPacket datagrampacket = new DatagramPacket(abyte0, abyte0.length);
                SnmpServer snmpServer = this;
                synchronized (snmpServer) {
                    this.receive_socket.receive(datagrampacket);
                }
                this.pooledExecutor.execute((Runnable)new ExecuteRunnable(datagrampacket, this));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.receive_socket.close();
    }

    private void execute(DatagramPacket datagrampacket) throws IOException {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(datagrampacket.getData(), 0, datagrampacket.getLength());
        if (new String(datagrampacket.getData()).trim().equals("SNMP_AGENT_STOP_MSG")) {
            this.receive_socket.close();
            this.receive_socket = null;
            this.send_socket = null;
            return;
        }
        AsnObject asnobject = AsnFactory.extractAsnObject(bytearrayinputstream);
        if (asnobject != null && asnobject instanceof AsnSequence) {
            SnmpMessage snmpmessage = new SnmpMessage((AsnSequence)asnobject, this.snmpDispatcher.security);
            if (snmpmessage.getSnmpVersion() > this.snmpAgent.getSnmpVersion()) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_18_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_18_LEVEL, JeusMessage_SNMP.SNMP_18);
                }
                snmpmessage.errorStatus = 23;
            } else if (snmpmessage.getSnmpVersion() < 3L && this.snmpAgent.isSecurityEnabled()) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_19_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_19_LEVEL, JeusMessage_SNMP.SNMP_19);
                }
                snmpmessage.errorStatus = 16;
            } else {
                byte[] abyte1 = new byte[datagrampacket.getLength()];
                byte[] abyte2 = datagrampacket.getData();
                for (int i = 0; i < abyte1.length; ++i) {
                    abyte1[i] = abyte2[i];
                }
                if (!Authenticator.doSnmpAuthentication(abyte1, false, -1, null, this.snmpDispatcher.security)) {
                    if (logger.isLoggable(JeusMessage_SNMP.SNMP_20_LEVEL)) {
                        logger.log(JeusMessage_SNMP.SNMP_20_LEVEL, JeusMessage_SNMP.SNMP_20);
                    }
                    snmpmessage.errorStatus = 16;
                    snmpmessage.secFailureReason = "1.3.6.1.6.3.15.1.1.5";
                }
            }
            SnmpMessageEvent snmpmessageevent = new SnmpMessageEvent(datagrampacket.getAddress(), datagrampacket.getPort(), snmpmessage);
            this.notifyListeners(snmpmessageevent);
        }
    }

    public void sendSnmpMessage(InetAddress inetaddress, int i, SnmpMessage snmpmessage) throws IOException {
        AsnSequence asnsequence = snmpmessage.createAsnSequence(this.snmpDispatcher.security);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        asnsequence.write(bytearrayoutputstream);
        bytearrayoutputstream.close();
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        byte[] abyte1 = snmpmessage.getAuthPassword();
        int j = snmpmessage.getAuthAlgorithm();
        Authenticator.doSnmpAuthentication(abyte0, true, j, abyte1, this.snmpDispatcher.security);
        DatagramPacket datagrampacket = new DatagramPacket(abyte0, abyte0.length, inetaddress, i);
        if (this.send_socket != null) {
            this.send_socket.send(datagrampacket);
        }
    }

    public void setDefaultPort(int i) {
        defaultPort = i;
    }

    protected String threeChar(byte byte0) {
        int i = byte0;
        if (i < 0) {
            i = 0x7F & byte0;
            i += 128;
        }
        if (i < 10) {
            return "00" + i;
        }
        if (i < 100) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    class ExecuteRunnable
    implements Runnable {
        private DatagramPacket packet;
        private SnmpServer snmpserver;

        public ExecuteRunnable(DatagramPacket _packet, SnmpServer _snmpserver) {
            this.packet = _packet;
            this.snmpserver = _snmpserver;
        }

        public void run() {
            try {
                this.snmpserver.execute(this.packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

