/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import jeus.ejb.util.CodeWriter;
import pt.ipb.agentapi.mibs.MibException;
import pt.ipb.agentapi.mibs.MibModule;
import pt.ipb.agentapi.mibs.MibNode;
import pt.ipb.agentapi.mibs.MibOps;

public class MibToSnmpSupport {
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp = File.separator.equals("/") ? new String(":") : new String(";");
    private MibOps ops = new MibOps();
    private String logLevel;

    public MibToSnmpSupport(String fName, String logLevel) throws FileNotFoundException, MibException {
        this.ops.loadMib(fName);
        this.logLevel = logLevel;
    }

    private void children(int level, MibNode node) {
        if (node != null) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                MibNode child = (MibNode)e.nextElement();
                this.children(level + 2, child);
            }
            BufferedOutputStream outputStream = null;
            try {
                MibNode parent = node.getParent();
                if (parent != null && parent.getOID().toString().equals(".1.3.6.1.4.1.14586.100")) {
                    String mbeanClassName = node.getLabel();
                    mbeanClassName = mbeanClassName.substring(0, 1).toUpperCase() + mbeanClassName.substring(1);
                    File snmpSupportFile = new File(mbeanClassName.replace('.', fsc) + "SnmpSupport.java");
                    outputStream = new BufferedOutputStream(new FileOutputStream(snmpSupportFile));
                    CodeWriter out = new CodeWriter(outputStream);
                    out.write("/* COPYRIGHT (c) 2004 by TMAX SOFT Inc. Korea");
                    out.write("* All Rights Reserved.");
                    out.write("*");
                    out.write("* It's generated from TMAX-JEUS-MIB.mib file by MibToSnmpSupport.");
                    out.write("*");
                    out.write("* Contact : chchoi89@tmax.co.kr");
                    out.write("* Made by : changho choi, Tmax Soft.co.");
                    out.write("*/");
                    out.write("");
                    out.write("package jeus.management.snmp.adaptor;");
                    out.write("");
                    out.write("import java.rmi.RemoteException;");
                    out.write("import jeus.management.snmp.agent.SnmpAgentForRMIImpl;");
                    out.write("");
                    out.write("public class " + mbeanClassName + "SnmpSupport extends SnmpSupport {");
                    out.write("");
                    out.write("    public " + mbeanClassName + "SnmpSupport() {");
                    out.write("        MBEAN_NAME = \"" + mbeanClassName + "MBean\";");
                    out.write("        ");
                    out.write("        // try to connect remotely, else get local reference");
                    out.write("        if (!connectToSnmpAgent())");
                    out.write("            snmpAgent = SnmpAgentForRMIImpl.getSnmpAgent();");
                    out.write("        ");
                    out.write("        try {");
                    out.write("            initialize();");
                    out.write("        } catch (Throwable t) {");
                    out.write("            jeus.util.Logger.log(\"[" + mbeanClassName + "SnmpSupport] Can't add OID\", t, jeus.util.Logger.FATAL);");
                    out.write("        }");
                    out.write("    }");
                    out.write("");
                    out.write("    public void initialize() throws RemoteException {");
                    if (this.logLevel.toUpperCase().equals("JMX")) {
                        System.out.println("attrs = new Vector();");
                        System.out.println("attributes.put(\"" + mbeanClassName + "\", attrs);");
                    }
                    Enumeration e2 = node.children();
                    while (e2.hasMoreElements()) {
                        MibNode child = (MibNode)e2.nextElement();
                        if (this.logLevel.toUpperCase().equals("SNMP")) {
                            System.out.println("\"" + child.getOID().toString().substring(1) + "\",");
                        } else if (this.logLevel.toUpperCase().equals("DEFAULT")) {
                            System.out.println(child.getOID().toString().substring(1) + " " + mbeanClassName + "." + child.getLabel());
                        } else if (this.logLevel.toUpperCase().equals("JMX")) {
                            System.out.println("attrs.add(\"" + child.getLabel() + "\");");
                        }
                        out.write("        add(\"" + child.getOID().toString().substring(1) + "\", \"" + MibToSnmpSupport.replaceStringOnce(child.getLabel(), node.getLabel(), "") + "\");");
                    }
                    out.write("    }");
                    out.write("");
                    out.write("}");
                    ((OutputStream)outputStream).flush();
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static String replaceStringOnce(String in, String cha, String num) {
        int ptr = 0;
        int diff = num.length();
        int len = cha.length();
        if (in.indexOf(cha, ptr) < 0) {
            return in;
        }
        int loc = in.indexOf(cha, ptr);
        in = in.substring(0, loc) + num + in.substring(loc + len);
        return in;
    }

    private void generate() {
        Enumeration e = this.ops.modules();
        while (e.hasMoreElements()) {
            MibModule module = (MibModule)e.nextElement();
            MibNode root = module.getRoot();
            this.children(2, root);
        }
    }

    public static void main(String[] args) {
        try {
            String mibFileName = args[0];
            String logLevel = "default";
            if (args.length == 2) {
                logLevel = args[1];
            }
            MibToSnmpSupport mibToSnmpSupport = new MibToSnmpSupport(mibFileName, logLevel);
            mibToSnmpSupport.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

