/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.tool;

import java.io.IOException;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.SnmpClient;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessage;

public class SnmpTestClient {
    private static final int SNMP_GET_TYPE = 1;
    private static final int SNMP_GETNEXT_TYPE = 2;
    private static int defaultPort = 161;
    private static String defaultIP = "127.0.0.1";
    private static String defaultOid = "1.3.6.1.4.1.14586.100.2.1";
    private static int defaultSnmpType = 2;
    private static boolean defaultIsSecurity = false;
    private static int defaultSnmpVersion = 1;
    private static String defaultUser = "";
    private static String defaultPassword = "";
    private static boolean isAll = false;
    private static String beforeOid = "";
    private static SnmpMessage snmpMessage;
    private static SnmpGetSetPdu getSetPdu;
    private static SnmpClient client;

    static void testGetWithSecutiry(String oid, boolean security) throws IOException {
        snmpMessage = new SnmpMessage();
        getSetPdu = new SnmpGetSetPdu();
        switch (defaultSnmpType) {
            case 1: {
                getSetPdu.setMsgType((byte)-96);
                break;
            }
            case 2: {
                getSetPdu.setMsgType((byte)-95);
                break;
            }
            default: {
                getSetPdu.setMsgType((byte)-95);
            }
        }
        getSetPdu.setReqId(1L);
        snmpMessage.setPdu(getSetPdu);
        if (defaultSnmpVersion != 3) {
            SnmpTestClient.usage();
            return;
        }
        snmpMessage.setSnmpVersion(defaultSnmpVersion);
        snmpMessage.setAuthMode(security);
        if (security) {
            snmpMessage.setAuthAlgorithm(1);
            snmpMessage.setUserName(defaultUser.getBytes());
            snmpMessage.setAuthPassword(defaultPassword.getBytes());
        }
        snmpMessage.setContextEngineID("test engine");
        snmpMessage.setContextName("test name");
        getSetPdu.addNameValuePair(new AsnNameValuePair(oid, new AsnNull()));
        System.out.println("Sending ... ");
        client.sendSnmpMessage(defaultIP, defaultPort, snmpMessage);
        System.out.println("Reply : ");
        SnmpGetSetPdu reply = (SnmpGetSetPdu)snmpMessage.getPdu();
        System.out.println(" PDU type : " + reply.getMsgTypeName());
        System.out.println(" error status : " + reply.getErrorStatus());
        System.out.println(" error index  : " + reply.getErrorIndex());
        if (!isAll) {
            for (int i = 0; i < reply.getValueSize(); ++i) {
                System.out.println(reply.getNameValuePair(i).toString());
            }
        } else {
            int lastIndex = -1;
            for (int i = 0; i < reply.getValueSize(); ++i) {
                lastIndex = i;
                System.out.println(reply.getNameValuePair(i).toString());
            }
            if (lastIndex == -1 || beforeOid.equals(reply.getNameValuePair(lastIndex).getName().toString())) {
                return;
            }
            beforeOid = reply.getNameValuePair(lastIndex).getName().toString();
            SnmpTestClient.testGetWithSecutiry(reply.getNameValuePair(lastIndex).getName().toString(), true);
        }
    }

    static void testGetWithoutSecutiry(String oid) throws IOException {
        snmpMessage = new SnmpMessage();
        getSetPdu = new SnmpGetSetPdu();
        switch (defaultSnmpType) {
            case 1: {
                getSetPdu.setMsgType((byte)-96);
                break;
            }
            case 2: {
                getSetPdu.setMsgType((byte)-95);
                break;
            }
            default: {
                getSetPdu.setMsgType((byte)-95);
            }
        }
        getSetPdu.setReqId(2L);
        snmpMessage.setPdu(getSetPdu);
        if (defaultIsSecurity || defaultSnmpVersion == 3) {
            SnmpTestClient.usage();
            return;
        }
        snmpMessage.setSnmpVersion(defaultSnmpVersion);
        snmpMessage.setContextEngineID("test engine");
        snmpMessage.setContextName("test name");
        getSetPdu.addNameValuePair(new AsnNameValuePair(oid, new AsnNull()));
        System.out.println("Sending ... ");
        client.sendSnmpMessage(defaultIP, defaultPort, snmpMessage);
        System.out.println("Reply : ");
        SnmpGetSetPdu reply = (SnmpGetSetPdu)snmpMessage.getPdu();
        System.out.println(" PDU type : " + reply.getMsgTypeName());
        System.out.println(" error status : " + reply.getErrorStatus());
        System.out.println(" error index  : " + reply.getErrorIndex());
        if (!isAll) {
            for (int i = 0; i < reply.getValueSize(); ++i) {
                System.out.println(reply.getNameValuePair(i).toString());
            }
        } else {
            int lastIndex = -1;
            for (int i = 0; i < reply.getValueSize(); ++i) {
                lastIndex = i;
                System.out.println(reply.getNameValuePair(i).toString());
            }
            if (lastIndex == -1 || beforeOid.equals(reply.getNameValuePair(lastIndex).getName().toString())) {
                return;
            }
            beforeOid = reply.getNameValuePair(lastIndex).getName().toString();
            SnmpTestClient.testGetWithoutSecutiry(reply.getNameValuePair(lastIndex).getName().toString());
        }
    }

    static void testStopSnmpAgent() {
    }

    public static void main(String[] args) {
        if (!SnmpTestClient.processArgs(args)) {
            SnmpTestClient.usage();
            return;
        }
        if (defaultOid.toLowerCase().equals("all")) {
            isAll = true;
            defaultOid = "1.3.6.1.4.1.14586.100.2.1";
            defaultSnmpType = 2;
        }
        SnmpTestClient.printInfo();
        try {
            if (defaultIsSecurity) {
                SnmpTestClient.testGetWithSecutiry(defaultOid, true);
            } else {
                SnmpTestClient.testGetWithoutSecutiry(defaultOid);
            }
        }
        catch (Exception ex) {
            System.out.println("ex *** : " + ex);
            ex.printStackTrace();
        }
    }

    public static boolean processArgs(String[] args) {
        if (args == null) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() < 3) {
                return false;
            }
            try {
                if (args[i].toLowerCase().startsWith("-a")) {
                    defaultIP = args[i].substring(2);
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-p")) {
                    defaultPort = Integer.parseInt(args[i].substring(2));
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-o")) {
                    defaultOid = args[i].substring(2);
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-m")) {
                    String type = args[i].substring(2).toLowerCase();
                    if (type.equals("get")) {
                        defaultSnmpType = 1;
                        continue;
                    }
                    if (type.equals("getnext")) {
                        defaultSnmpType = 2;
                        continue;
                    }
                    defaultSnmpType = 2;
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-v")) {
                    defaultSnmpVersion = Integer.parseInt(args[i].substring(2));
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-s")) {
                    if (args[i].substring(2).toLowerCase().equals("true")) {
                        defaultIsSecurity = true;
                        continue;
                    }
                    defaultIsSecurity = false;
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-u")) {
                    defaultUser = args[i].substring(2);
                    continue;
                }
                if (args[i].toLowerCase().startsWith("-w")) {
                    defaultPassword = args[i].substring(2);
                    continue;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static void usage() {
        System.out.println("SnmpTestClient <option>");
        System.out.println("<option> information :");
        System.out.println("\t-a: snmp agent ip address , default is 127.0.0.1");
        System.out.println("\t-p: snmp agent port number, default is 161");
        System.out.println("\t-o: oid, all or a specific oid, default is 1.3.6.1.4.1.14586.100.2.1");
        System.out.println("\t-m: request message type, default is getnext. [ get | getnext ] is available");
        System.out.println("\t-v: snmp version, default is 1. [ 1 | 2 | 3 ] is available");
        System.out.println("\t-s: snmp security enable, default is false. [ true | false ] is available");
        System.out.println("\t-u: username if you use a  snmp client with security");
        System.out.println("\t-w: password if you use a  snmp client with security");
        System.out.println("\t-help: you need help informations");
        System.out.println("ex1) SnmpTestClient -a127.0.0.1 -p161 -o1.3.6.1.4.1.14586.100.2.1 -mgetnext");
        System.out.println("ex2) SnmpTestClient -a127.0.0.1 -p161 -oall");
        System.out.println("ex3) SnmpTestClient -help");
    }

    public static void printInfo() {
        System.out.println("** Information **");
        System.out.println("[ip address] : " + defaultIP);
        System.out.println("[port] : " + defaultPort);
        System.out.println("[oid] : " + defaultOid);
        switch (defaultSnmpType) {
            case 1: {
                System.out.println("[type] : GET");
                break;
            }
            case 2: {
                System.out.println("[type] : GETNEXT");
            }
        }
        System.out.println("[version] : " + defaultSnmpVersion);
        System.out.println("[security] : " + defaultIsSecurity);
        if (defaultIsSecurity) {
            System.out.println("[username] : " + defaultUser);
            System.out.println("[password] : " + defaultPassword);
        }
    }

    static {
        client = new SnmpClient();
    }
}

