/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jeus.util.properties.JeusManagerProperties;

public class JeusSSLConfiguration {
    public static final SSLContext sslContext;

    public static SSLContext createSSLContext() {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] passphrase = JeusManagerProperties.SSL_KEYPASS.toCharArray();
            FileInputStream fin = new FileInputStream(JeusManagerProperties.SSL_KEYSTORE);
            ks.load(fin, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            fin.close();
            KeyStore ts = KeyStore.getInstance("JKS");
            passphrase = JeusManagerProperties.SSL_TRUSTPASS.toCharArray();
            fin = new FileInputStream(JeusManagerProperties.SSL_TRUSTSTORE);
            ts.load(fin, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            fin.close();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    static {
        try {
            sslContext = JeusSSLConfiguration.createSSLContext();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

