/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.util.Map;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jeus.persistence.container.ManagedEntityManager;
import jeus.persistence.container.ManagedEntityManagerFactory;
import jeus.persistence.container.PersistenceUnits;
import jeus.transaction.TransactionLocal;
import jeus.transaction.TxHelper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JPA;

public class PersistenceUnit {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.persistence");
    protected static final TransactionManager tm = TxHelper.getTransactionManager();
    protected PersistenceUnits persistenceUnits;
    protected String unitName;
    protected EntityManagerFactory emf;
    protected TransactionLocal<EntityManager> txLocal = new TransactionLocal();

    protected PersistenceUnit(PersistenceUnits pus, String unitName, EntityManagerFactory emf) {
        this.persistenceUnits = pus;
        this.unitName = unitName;
        this.emf = emf;
    }

    public PersistenceUnits getPersistenceUnits() {
        return this.persistenceUnits;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public ManagedEntityManagerFactory createManagedEntityManagerFactory() {
        return new ManagedEntityManagerFactory(this);
    }

    public ManagedEntityManager createManagedEntityManager(PersistenceContextType type, Map properties) {
        if (type == null) {
            throw new NullPointerException();
        }
        ManagedEntityManager entityManager = new ManagedEntityManager(this, type, properties);
        return entityManager;
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public EntityManager createEntityManager(Map properties) {
        return this.emf.createEntityManager(properties);
    }

    void close() {
        try {
            if (this.emf.isOpen()) {
                this.emf.close();
            }
            if (logger.isLoggable(JeusMessage_JPA._21_LEVEL)) {
                logger.log(JeusMessage_JPA._21_LEVEL, JeusMessage_JPA._21, (Object)this.unitName);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public EntityManager getTxAssociatedPersistenceContext() {
        return this.txLocal.get();
    }

    public void associatePersistenceContextWithTx(EntityManager pc, PersistenceContextType type) {
        assert (pc != null && type != null);
        pc.joinTransaction();
        this.txLocal.set(pc);
        try {
            Transaction tx = tm.getTransaction();
            PersistenceContextSynchronization synchronization = new PersistenceContextSynchronization(pc, type);
            tx.registerSynchronization((Synchronization)synchronization);
            logger.log(JeusMessage_JPA._22_LEVEL, JeusMessage_JPA._22, new Object[]{pc, tx});
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex);
        }
        catch (RollbackException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex);
        }
    }

    private class PersistenceContextSynchronization
    implements Synchronization {
        EntityManager pc;
        PersistenceContextType type;

        public PersistenceContextSynchronization(EntityManager pc, PersistenceContextType type) {
            this.pc = pc;
            this.type = type;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.type == PersistenceContextType.TRANSACTION) {
                logger.log(JeusMessage_JPA._23_LEVEL, JeusMessage_JPA._23, (Object)this.pc);
                this.pc.close();
            }
        }
    }
}

